/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMultifactorAuthenticationTriggerSelectionStrategy
implements MultifactorAuthenticationTriggerSelectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultifactorAuthenticationTriggerSelectionStrategy.class);
    private final Collection<MultifactorAuthenticationTrigger> multifactorAuthenticationTriggers;

    public Optional<MultifactorAuthenticationProvider> resolve(HttpServletRequest request, HttpServletResponse response, RegisteredService registeredService, Authentication authentication, Service service) {
        if (registeredService != null && registeredService.getMultifactorPolicy().isBypassEnabled()) {
            LOGGER.debug("Multifactor authentication policy for [{}] will ignore trigger executions", (Object)registeredService.getName());
            return Optional.empty();
        }
        for (MultifactorAuthenticationTrigger trigger : this.multifactorAuthenticationTriggers) {
            Optional activated;
            if (!trigger.supports(request, registeredService, authentication, service) || !(activated = trigger.isActivated(authentication, registeredService, request, response, service)).isPresent()) continue;
            return activated;
        }
        return Optional.empty();
    }

    @Generated
    public DefaultMultifactorAuthenticationTriggerSelectionStrategy(Collection<MultifactorAuthenticationTrigger> multifactorAuthenticationTriggers) {
        this.multifactorAuthenticationTriggers = multifactorAuthenticationTriggers;
    }

    @Generated
    public Collection<MultifactorAuthenticationTrigger> getMultifactorAuthenticationTriggers() {
        return this.multifactorAuthenticationTriggers;
    }
}

