/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.web;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.web.bind.annotation.GetMapping;

@RestControllerEndpoint(id="events", enableByDefault=false)
public class CasEventsReportEndpoint
extends BaseCasActuatorEndpoint {
    private static final long LIMIT = 1000L;
    private final CasEventRepository eventRepository;

    public CasEventsReportEndpoint(CasConfigurationProperties casProperties, CasEventRepository eventRepository) {
        super(casProperties);
        this.eventRepository = eventRepository;
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Provide a report of CAS events in the event repository")
    public List<? extends CasEvent> events() {
        return this.eventRepository.load().sorted(Comparator.comparingLong(CasEvent::getTimestamp).reversed()).limit(1000L).collect(Collectors.toList());
    }
}

