/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.listener;

import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.support.events.config.CasConfigurationModifiedEvent;
import org.apereo.cas.support.events.listener.CasConfigurationEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationContext;

public class DefaultCasConfigurationEventListener
implements CasConfigurationEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasConfigurationEventListener.class);
    private final CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager;
    private final ConfigurationPropertiesBindingPostProcessor binder;
    private final ContextRefresher contextRefresher;
    private final ApplicationContext applicationContext;

    @Override
    public void handleRefreshEvent(EnvironmentChangeEvent event) {
        LOGGER.trace("Received event [{}]", (Object)event);
        this.rebind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConfigurationModifiedEvent(CasConfigurationModifiedEvent event) {
        if (event.isEligibleForContextRefresh()) {
            LOGGER.info("Received event [{}]. Refreshing CAS configuration...", (Object)event);
            Set keys = null;
            try {
                keys = this.contextRefresher.refresh();
                LOGGER.debug("Refreshed the following settings: [{}].", (Object)keys);
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
            finally {
                this.rebind();
                LOGGER.info("CAS finished rebinding configuration with new settings [{}]", ObjectUtils.defaultIfNull((Object)keys, new ArrayList(0)));
            }
        }
    }

    private void rebind() {
        LOGGER.info("Refreshing CAS configuration. Stand by...");
        if (this.configurationPropertiesEnvironmentManager != null) {
            this.configurationPropertiesEnvironmentManager.rebindCasConfigurationProperties(this.applicationContext);
        } else {
            CasConfigurationPropertiesEnvironmentManager.rebindCasConfigurationProperties((ConfigurationPropertiesBindingPostProcessor)this.binder, (ApplicationContext)this.applicationContext);
        }
    }

    @Generated
    public DefaultCasConfigurationEventListener(CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager, ConfigurationPropertiesBindingPostProcessor binder, ContextRefresher contextRefresher, ApplicationContext applicationContext) {
        this.configurationPropertiesEnvironmentManager = configurationPropertiesEnvironmentManager;
        this.binder = binder;
        this.contextRefresher = contextRefresher;
        this.applicationContext = applicationContext;
    }
}

