/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications.mail;

import jakarta.mail.internet.MimeMessage;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.mail.EmailSender;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class DefaultEmailSender
implements EmailSender {
    private final JavaMailSender mailSender;
    private final HierarchicalMessageSource messageSource;

    @Override
    public boolean canSend() {
        return this.mailSender != null;
    }

    @Override
    public EmailCommunicationResult send(EmailMessageRequest emailRequest) throws Exception {
        List<String> recipients = emailRequest.getRecipients();
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message);
        helper.setTo(recipients.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        helper.setText(emailRequest.getBody(), emailRequest.getEmailProperties().isHtml());
        String subject = this.determineEmailSubject(emailRequest, this.messageSource);
        helper.setSubject(subject);
        helper.setFrom(emailRequest.getEmailProperties().getFrom());
        FunctionUtils.doIfNotBlank((CharSequence)emailRequest.getEmailProperties().getReplyTo(), __ -> helper.setReplyTo(emailRequest.getEmailProperties().getReplyTo()));
        helper.setValidateAddresses(emailRequest.getEmailProperties().isValidateAddresses());
        helper.setPriority(emailRequest.getEmailProperties().getPriority());
        helper.setCc(emailRequest.getEmailProperties().getCc().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        helper.setBcc(emailRequest.getEmailProperties().getBcc().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        this.mailSender.send(message);
        return ((EmailCommunicationResult.EmailCommunicationResultBuilder)((EmailCommunicationResult.EmailCommunicationResultBuilder)((EmailCommunicationResult.EmailCommunicationResultBuilder)EmailCommunicationResult.builder().success(true)).to(recipients)).body(emailRequest.getBody())).build();
    }

    @Generated
    public DefaultEmailSender(JavaMailSender mailSender, HierarchicalMessageSource messageSource) {
        this.mailSender = mailSender;
        this.messageSource = messageSource;
    }
}

