/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.internet.MimeMessage;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.push.NotificationSender;
import org.apereo.cas.notifications.sms.SmsSender;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class DefaultCommunicationsManager
implements CommunicationsManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCommunicationsManager.class);
    private final SmsSender smsSender;
    private final JavaMailSender mailSender;
    private final NotificationSender notificationSender;

    private static Optional<Object> getFirstAttributeByName(Principal principal, String attribute) {
        List value = (List)principal.getAttributes().get(attribute);
        return CollectionUtils.firstElement((Object)value);
    }

    @Override
    public boolean isMailSenderDefined() {
        return this.mailSender != null;
    }

    @Override
    public boolean isSmsSenderDefined() {
        return this.smsSender != null && this.smsSender.canSend();
    }

    @Override
    public boolean isNotificationSenderDefined() {
        return this.notificationSender != null && this.notificationSender.canSend();
    }

    @Override
    public boolean notify(Principal principal, String title, String body) {
        return this.notificationSender.notify(principal, Map.of("title", title, "message", body));
    }

    @Override
    public boolean email(Principal principal, String attribute, EmailProperties emailProperties, String body) {
        Optional<Object> to;
        if (StringUtils.isNotBlank((CharSequence)attribute) && principal.getAttributes().containsKey(attribute) && this.isMailSenderDefined() && (to = DefaultCommunicationsManager.getFirstAttributeByName(principal, attribute)).isPresent()) {
            return this.email(emailProperties, to.get().toString(), body);
        }
        LOGGER.debug("Email attribute [{}] cannot be found or no configuration for email provider is defined", (Object)attribute);
        return false;
    }

    @Override
    public boolean email(EmailProperties emailProperties, String to, String body) {
        try {
            LOGGER.trace("Attempting to send email [{}] to [{}]", (Object)body, (Object)to);
            if (!this.isMailSenderDefined() || emailProperties.isUndefined() || StringUtils.isBlank((CharSequence)to)) {
                throw new IllegalAccessException("Could not send email; from/to/subject/text or email settings are undefined.");
            }
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message);
            helper.setTo(to);
            helper.setText(body, emailProperties.isHtml());
            String subject = SpringExpressionLanguageValueResolver.getInstance().resolve(emailProperties.getSubject());
            helper.setSubject(subject);
            helper.setFrom(emailProperties.getFrom());
            if (StringUtils.isNotBlank((CharSequence)emailProperties.getReplyTo())) {
                helper.setReplyTo(emailProperties.getReplyTo());
            }
            helper.setValidateAddresses(emailProperties.isValidateAddresses());
            helper.setPriority(1);
            if (StringUtils.isNotBlank((CharSequence)emailProperties.getCc())) {
                helper.setCc(emailProperties.getCc());
            }
            if (StringUtils.isNotBlank((CharSequence)emailProperties.getBcc())) {
                helper.setBcc(emailProperties.getBcc());
            }
            this.mailSender.send(message);
            return true;
        }
        catch (Exception ex) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean sms(Principal principal, String attribute, String text, String from) {
        Optional<Object> to;
        if (StringUtils.isNotBlank((CharSequence)attribute) && principal.getAttributes().containsKey(attribute) && this.isSmsSenderDefined() && (to = DefaultCommunicationsManager.getFirstAttributeByName(principal, attribute)).isPresent()) {
            return this.sms(from, to.get().toString(), text);
        }
        LOGGER.debug("Phone attribute [{}] cannot be found or no configuration for sms provider is defined", (Object)attribute);
        return false;
    }

    @Override
    public boolean sms(String from, String to, String text) {
        if (!this.isSmsSenderDefined() || StringUtils.isBlank((CharSequence)text) || StringUtils.isBlank((CharSequence)from)) {
            LOGGER.warn("Could not send SMS to [{}] because either no from/text is found or SMS settings are not configured.", (Object)to);
            return false;
        }
        return this.smsSender.send(from, to, text);
    }

    @Override
    public boolean validate() {
        if (!this.isMailSenderDefined()) {
            LOGGER.info("CAS is unable to send email given no settings are defined to account for email servers, etc");
        }
        if (!this.isSmsSenderDefined()) {
            LOGGER.info("CAS is unable to send sms messages given no settings are defined to account for sms providers, etc");
        }
        if (!this.isNotificationSenderDefined()) {
            LOGGER.info("CAS is unable to send notifications given no providers are defined to handle messages, etc");
        }
        return this.isMailSenderDefined() || this.isSmsSenderDefined() || this.isNotificationSenderDefined();
    }

    @Generated
    public DefaultCommunicationsManager(SmsSender smsSender, JavaMailSender mailSender, NotificationSender notificationSender) {
        this.smsSender = smsSender;
        this.mailSender = mailSender;
        this.notificationSender = notificationSender;
    }
}

