/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DefaultRegisteredServiceDelegatedAuthenticationPolicy
implements RegisteredServiceDelegatedAuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServiceDelegatedAuthenticationPolicy.class);
    private static final long serialVersionUID = -784106970642770923L;
    private Collection<String> allowedProviders = new LinkedHashSet<String>(0);
    private boolean permitUndefined = true;
    private boolean exclusive;

    @JsonIgnore
    public boolean isProviderAllowed(String provider, RegisteredService registeredService) {
        if (this.getAllowedProviders() == null || this.getAllowedProviders().isEmpty()) {
            LOGGER.warn("Registered service [{}] does not define any authorized/supported delegated authentication providers. It is STRONGLY recommended that you authorize and assign providers to the service definition. While just a warning for now, this behavior will be enforced by CAS in future versions.", (Object)registeredService.getName());
            return this.permitUndefined;
        }
        return this.getAllowedProviders().contains(provider);
    }

    @Generated
    public String toString() {
        return "DefaultRegisteredServiceDelegatedAuthenticationPolicy(allowedProviders=" + this.allowedProviders + ", permitUndefined=" + this.permitUndefined + ", exclusive=" + this.exclusive + ")";
    }

    @Generated
    public Collection<String> getAllowedProviders() {
        return this.allowedProviders;
    }

    @Generated
    public boolean isPermitUndefined() {
        return this.permitUndefined;
    }

    @Generated
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Generated
    public DefaultRegisteredServiceDelegatedAuthenticationPolicy setAllowedProviders(Collection<String> allowedProviders) {
        this.allowedProviders = allowedProviders;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceDelegatedAuthenticationPolicy setPermitUndefined(boolean permitUndefined) {
        this.permitUndefined = permitUndefined;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceDelegatedAuthenticationPolicy setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceDelegatedAuthenticationPolicy)) {
            return false;
        }
        DefaultRegisteredServiceDelegatedAuthenticationPolicy other = (DefaultRegisteredServiceDelegatedAuthenticationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.permitUndefined != other.permitUndefined) {
            return false;
        }
        return this.exclusive == other.exclusive;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceDelegatedAuthenticationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.permitUndefined ? 79 : 97);
        result = result * 59 + (this.exclusive ? 79 : 97);
        return result;
    }

    @Generated
    public DefaultRegisteredServiceDelegatedAuthenticationPolicy(Collection<String> allowedProviders, boolean permitUndefined, boolean exclusive) {
        this.allowedProviders = allowedProviders;
        this.permitUndefined = permitUndefined;
        this.exclusive = exclusive;
    }

    @Generated
    public DefaultRegisteredServiceDelegatedAuthenticationPolicy() {
    }
}

