/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Transient;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.BaseRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class GroovyRegisteredServiceAccessStrategy
extends BaseRegisteredServiceAccessStrategy {
    private static final long serialVersionUID = -2407494148882123062L;
    private int order;
    @ExpressionLanguageCapable
    private String groovyScript;
    @JsonIgnore
    @Transient
    @org.springframework.data.annotation.Transient
    private transient WatchableGroovyScriptResource watchableScript;

    public boolean isServiceAccessAllowed(RegisteredService registeredService, Service service) {
        try {
            this.buildGroovyAccessStrategyInstanceIfNeeded();
            return Boolean.TRUE.equals(this.watchableScript.execute("isServiceAccessAllowed", Boolean.class, new Object[]{registeredService, service}));
        }
        catch (Throwable throwable) {
            throw UnauthorizedServiceException.wrap((Throwable)throwable);
        }
    }

    public boolean isServiceAccessAllowedForSso(RegisteredService registeredService) {
        try {
            this.buildGroovyAccessStrategyInstanceIfNeeded();
            return Boolean.TRUE.equals(this.watchableScript.execute("isServiceAccessAllowedForSso", Boolean.class, new Object[]{registeredService}));
        }
        catch (Throwable throwable) {
            throw UnauthorizedServiceException.wrap((Throwable)throwable);
        }
    }

    public boolean authorizeRequest(RegisteredServiceAccessStrategyRequest request) throws Throwable {
        try {
            this.buildGroovyAccessStrategyInstanceIfNeeded();
            return Boolean.TRUE.equals(this.watchableScript.execute("authorizeRequest", Boolean.class, new Object[]{request}));
        }
        catch (Throwable throwable) {
            throw UnauthorizedServiceException.wrap((Throwable)throwable);
        }
    }

    protected void buildGroovyAccessStrategyInstanceIfNeeded() {
        if (this.watchableScript == null) {
            AbstractResource groovyResource = (AbstractResource)FunctionUtils.doUnchecked(() -> {
                String location = SpringExpressionLanguageValueResolver.getInstance().resolve(this.groovyScript);
                return ResourceUtils.getResourceFrom((String)location);
            });
            this.watchableScript = new WatchableGroovyScriptResource((Resource)groovyResource).setFailOnError(false);
        }
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public WatchableGroovyScriptResource getWatchableScript() {
        return this.watchableScript;
    }

    @Generated
    public GroovyRegisteredServiceAccessStrategy setOrder(int order) {
        this.order = order;
        return this;
    }

    @Generated
    public GroovyRegisteredServiceAccessStrategy setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
        return this;
    }

    @JsonIgnore
    @Generated
    public GroovyRegisteredServiceAccessStrategy setWatchableScript(WatchableGroovyScriptResource watchableScript) {
        this.watchableScript = watchableScript;
        return this;
    }

    @Generated
    public GroovyRegisteredServiceAccessStrategy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroovyRegisteredServiceAccessStrategy)) {
            return false;
        }
        GroovyRegisteredServiceAccessStrategy other = (GroovyRegisteredServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        String this$groovyScript = this.groovyScript;
        String other$groovyScript = other.groovyScript;
        return !(this$groovyScript == null ? other$groovyScript != null : !this$groovyScript.equals(other$groovyScript));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroovyRegisteredServiceAccessStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.order;
        String $groovyScript = this.groovyScript;
        result = result * 59 + ($groovyScript == null ? 43 : $groovyScript.hashCode());
        return result;
    }
}

