/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.GroovyShellScript;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceAccessStrategyEvaluator
implements Function<RegisteredServiceAccessStrategyRequest, Boolean> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceAccessStrategyEvaluator.class);
    private Map<String, Set<String>> requiredAttributes;
    private Map<String, Set<String>> rejectedAttributes;
    private boolean caseInsensitive;
    private boolean requireAllAttributes;

    @Override
    public Boolean apply(RegisteredServiceAccessStrategyRequest request) {
        if ((this.rejectedAttributes == null || this.rejectedAttributes.isEmpty()) && (this.requiredAttributes == null || this.requiredAttributes.isEmpty())) {
            LOGGER.trace("Skipping access strategy policy, since no attributes rules are defined");
            return true;
        }
        if (!this.enoughAttributesAvailableToProcess(request)) {
            LOGGER.debug("Access is denied. There are not enough attributes available to satisfy requirements");
            return false;
        }
        if (this.doRejectedAttributesRefusePrincipalAccess(request)) {
            LOGGER.debug("Access is denied. The principal carries attributes that would reject service access");
            return false;
        }
        if (!this.doRequiredAttributesAllowPrincipalAccess(request, this.requiredAttributes)) {
            LOGGER.debug("Access is denied. The principal does not have the required attributes [{}]", this.requiredAttributes);
            return false;
        }
        return true;
    }

    protected boolean doRequiredAttributesAllowPrincipalAccess(RegisteredServiceAccessStrategyRequest request, Map<String, Set<String>> requiredAttributes) {
        LOGGER.debug("These required attributes [{}] are examined against [{}] before service can proceed.", requiredAttributes, (Object)request.getAttributes());
        return requiredAttributes.isEmpty() || this.requiredAttributesFoundInMap(request, requiredAttributes);
    }

    protected boolean doRejectedAttributesRefusePrincipalAccess(RegisteredServiceAccessStrategyRequest request) {
        LOGGER.debug("These rejected attributes [{}] are examined against [{}] before service can proceed.", this.rejectedAttributes, (Object)request.getAttributes());
        return !this.rejectedAttributes.isEmpty() && this.requiredAttributesFoundInMap(request, this.rejectedAttributes);
    }

    protected boolean enoughAttributesAvailableToProcess(RegisteredServiceAccessStrategyRequest request) {
        if (!this.enoughRequiredAttributesAvailableToProcess(request.getAttributes(), this.requiredAttributes)) {
            return false;
        }
        if (request.getAttributes().size() < this.rejectedAttributes.size()) {
            LOGGER.debug("The size of the principal attributes that are [{}] does not match defined rejected attributes, which means the principal is not carrying enough data to grant authorization", (Object)request.getAttributes());
            return false;
        }
        return true;
    }

    protected boolean enoughRequiredAttributesAvailableToProcess(Map<String, List<Object>> principalAttributes, Map<String, Set<String>> requiredAttributes) {
        if (principalAttributes.isEmpty() && !requiredAttributes.isEmpty()) {
            LOGGER.debug("No principal attributes are found to satisfy defined attribute requirements");
            return false;
        }
        if (principalAttributes.size() < requiredAttributes.size()) {
            LOGGER.debug("The size of the principal attributes that are [{}] does not match defined required attributes, which indicates the principal is not carrying enough data to grant authorization", principalAttributes);
            return false;
        }
        return true;
    }

    protected boolean requiredAttributesFoundInMap(RegisteredServiceAccessStrategyRequest request, Map<String, Set<String>> requiredAttributes) {
        Set difference = requiredAttributes.keySet().stream().filter(key -> request.getAttributes().containsKey(key)).collect(Collectors.toSet());
        LOGGER.debug("Difference of checking required attributes: [{}]", difference);
        if (this.requireAllAttributes && difference.size() < requiredAttributes.size()) {
            return false;
        }
        Predicate attributeMatcherPredicate = Unchecked.predicate(key -> this.requiredAttributeFound((String)key, request, requiredAttributes));
        if (this.requireAllAttributes) {
            return difference.stream().allMatch(attributeMatcherPredicate);
        }
        return difference.stream().anyMatch(attributeMatcherPredicate);
    }

    protected boolean requiredAttributeFound(String attributeName, RegisteredServiceAccessStrategyRequest request, Map<String, Set<String>> requiredAttributes) throws Throwable {
        Set<String> requiredValues = requiredAttributes.get(attributeName);
        Set availableValues = CollectionUtils.toCollection(request.getAttributes().get(attributeName));
        ArrayList<Object> results = new ArrayList<Object>();
        for (String requiredValue : requiredValues) {
            Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)requiredValue);
            if (matcherInline.find() && CasRuntimeHintsRegistrar.notInNativeImage()) {
                GroovyShellScript executableScript = new GroovyShellScript(matcherInline.group(1));
                try {
                    Map args = CollectionUtils.wrap((String)"principalId", (Object)request.getPrincipalId(), (String)"currentValues", (Object)availableValues, (String)"attributes", (Object)request.getAttributes(), (String)"logger", (Object)LOGGER);
                    executableScript.setBinding(args);
                    results.add(executableScript.execute(args.values().toArray(), Boolean.class));
                    continue;
                }
                finally {
                    executableScript.close();
                    continue;
                }
            }
            Pattern pattern = RegexUtils.createPattern((String)requiredValue, (int)(this.caseInsensitive ? 2 : 0));
            LOGGER.debug("Checking [{}] against [{}] with pattern [{}] for attribute [{}]", new Object[]{requiredValues, availableValues, pattern, attributeName});
            if (pattern.equals(RegexUtils.MATCH_NOTHING_PATTERN)) {
                results.add(availableValues.stream().anyMatch(requiredValues::contains));
                continue;
            }
            results.add(availableValues.stream().map(Object::toString).anyMatch(pattern.asPredicate()));
        }
        return results.contains(true);
    }

    @Generated
    private static Map<String, Set<String>> $default$requiredAttributes() {
        return new HashMap<String, Set<String>>(0);
    }

    @Generated
    private static Map<String, Set<String>> $default$rejectedAttributes() {
        return new HashMap<String, Set<String>>(0);
    }

    @Generated
    private static boolean $default$requireAllAttributes() {
        return true;
    }

    @Generated
    protected RegisteredServiceAccessStrategyEvaluator(RegisteredServiceAccessStrategyEvaluatorBuilder<?, ?> b) {
        this.requiredAttributes = b.requiredAttributes$set ? b.requiredAttributes$value : RegisteredServiceAccessStrategyEvaluator.$default$requiredAttributes();
        this.rejectedAttributes = b.rejectedAttributes$set ? b.rejectedAttributes$value : RegisteredServiceAccessStrategyEvaluator.$default$rejectedAttributes();
        this.caseInsensitive = b.caseInsensitive;
        this.requireAllAttributes = b.requireAllAttributes$set ? b.requireAllAttributes$value : RegisteredServiceAccessStrategyEvaluator.$default$requireAllAttributes();
    }

    @Generated
    public static RegisteredServiceAccessStrategyEvaluatorBuilder<?, ?> builder() {
        return new RegisteredServiceAccessStrategyEvaluatorBuilderImpl();
    }

    @Generated
    public Map<String, Set<String>> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @Generated
    public Map<String, Set<String>> getRejectedAttributes() {
        return this.rejectedAttributes;
    }

    @Generated
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Generated
    public boolean isRequireAllAttributes() {
        return this.requireAllAttributes;
    }

    @Generated
    public static abstract class RegisteredServiceAccessStrategyEvaluatorBuilder<C extends RegisteredServiceAccessStrategyEvaluator, B extends RegisteredServiceAccessStrategyEvaluatorBuilder<C, B>> {
        @Generated
        private boolean requiredAttributes$set;
        @Generated
        private Map<String, Set<String>> requiredAttributes$value;
        @Generated
        private boolean rejectedAttributes$set;
        @Generated
        private Map<String, Set<String>> rejectedAttributes$value;
        @Generated
        private boolean caseInsensitive;
        @Generated
        private boolean requireAllAttributes$set;
        @Generated
        private boolean requireAllAttributes$value;

        @Generated
        public B requiredAttributes(Map<String, Set<String>> requiredAttributes) {
            this.requiredAttributes$value = requiredAttributes;
            this.requiredAttributes$set = true;
            return this.self();
        }

        @Generated
        public B rejectedAttributes(Map<String, Set<String>> rejectedAttributes) {
            this.rejectedAttributes$value = rejectedAttributes;
            this.rejectedAttributes$set = true;
            return this.self();
        }

        @Generated
        public B caseInsensitive(boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
            return this.self();
        }

        @Generated
        public B requireAllAttributes(boolean requireAllAttributes) {
            this.requireAllAttributes$value = requireAllAttributes;
            this.requireAllAttributes$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RegisteredServiceAccessStrategyEvaluator.RegisteredServiceAccessStrategyEvaluatorBuilder(requiredAttributes$value=" + String.valueOf(this.requiredAttributes$value) + ", rejectedAttributes$value=" + String.valueOf(this.rejectedAttributes$value) + ", caseInsensitive=" + this.caseInsensitive + ", requireAllAttributes$value=" + this.requireAllAttributes$value + ")";
        }
    }

    @Generated
    private static final class RegisteredServiceAccessStrategyEvaluatorBuilderImpl
    extends RegisteredServiceAccessStrategyEvaluatorBuilder<RegisteredServiceAccessStrategyEvaluator, RegisteredServiceAccessStrategyEvaluatorBuilderImpl> {
        @Generated
        private RegisteredServiceAccessStrategyEvaluatorBuilderImpl() {
        }

        @Override
        @Generated
        protected RegisteredServiceAccessStrategyEvaluatorBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RegisteredServiceAccessStrategyEvaluator build() {
            return new RegisteredServiceAccessStrategyEvaluator(this);
        }
    }
}

