/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.persistence.PostLoad;
import jakarta.persistence.Transient;
import java.util.Map;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.RegisteredServiceAccessStrategyActivationCriteria;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledGroovyScript;
import org.apereo.cas.util.scripting.GroovyShellScript;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class GroovyRegisteredServiceAccessStrategyActivationCriteria
implements RegisteredServiceAccessStrategyActivationCriteria {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyRegisteredServiceAccessStrategyActivationCriteria.class);
    private static final long serialVersionUID = 5228603912161923218L;
    private int order;
    @ExpressionLanguageCapable
    private String groovyScript;
    @JsonIgnore
    @Transient
    @org.springframework.data.annotation.Transient
    private transient ExecutableCompiledGroovyScript executableScript;

    public boolean shouldActivate(RegisteredServiceAccessStrategyRequest request) throws Throwable {
        this.initializeWatchableScriptIfNeeded();
        return this.getGroovyAttributeValue(request);
    }

    protected Boolean getGroovyAttributeValue(RegisteredServiceAccessStrategyRequest request) throws Throwable {
        Map args = CollectionUtils.wrap((String)"accessRequest", (Object)request, (String)"logger", (Object)LOGGER);
        this.executableScript.setBinding(args);
        return (Boolean)this.executableScript.execute(args.values().toArray(), Boolean.class);
    }

    @PostLoad
    private void initializeWatchableScriptIfNeeded() {
        Matcher matcherInline;
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)this.groovyScript);
        if (matcherFile.find()) {
            String script = SpringExpressionLanguageValueResolver.getInstance().resolve(matcherFile.group());
            AbstractResource resource = (AbstractResource)FunctionUtils.doUnchecked(() -> ResourceUtils.getRawResourceFrom((String)script));
            this.executableScript = new WatchableGroovyScriptResource((Resource)resource);
        }
        if ((matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)this.groovyScript)).find() && CasRuntimeHintsRegistrar.notInNativeImage()) {
            this.executableScript = new GroovyShellScript(matcherInline.group(1));
        }
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public ExecutableCompiledGroovyScript getExecutableScript() {
        return this.executableScript;
    }

    @Generated
    public GroovyRegisteredServiceAccessStrategyActivationCriteria setOrder(int order) {
        this.order = order;
        return this;
    }

    @Generated
    public GroovyRegisteredServiceAccessStrategyActivationCriteria setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
        return this;
    }

    @JsonIgnore
    @Generated
    public GroovyRegisteredServiceAccessStrategyActivationCriteria setExecutableScript(ExecutableCompiledGroovyScript executableScript) {
        this.executableScript = executableScript;
        return this;
    }

    @Generated
    public GroovyRegisteredServiceAccessStrategyActivationCriteria() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroovyRegisteredServiceAccessStrategyActivationCriteria)) {
            return false;
        }
        GroovyRegisteredServiceAccessStrategyActivationCriteria other = (GroovyRegisteredServiceAccessStrategyActivationCriteria)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        String this$groovyScript = this.groovyScript;
        String other$groovyScript = other.groovyScript;
        return !(this$groovyScript == null ? other$groovyScript != null : !this$groovyScript.equals(other$groovyScript));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroovyRegisteredServiceAccessStrategyActivationCriteria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        String $groovyScript = this.groovyScript;
        result = result * 59 + ($groovyScript == null ? 43 : $groovyScript.hashCode());
        return result;
    }
}

