/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.AbstractServiceFactory;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.validation.ValidationResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationServiceFactory
extends AbstractServiceFactory<WebApplicationService> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplicationServiceFactory.class);

    private static AbstractWebApplicationService determineWebApplicationFormat(HttpServletRequest request, AbstractWebApplicationService webApplicationService) {
        String format = Optional.ofNullable(request).map(httpServletRequest -> httpServletRequest.getParameter("format")).orElse("");
        try {
            if (StringUtils.isNotBlank((CharSequence)format)) {
                ValidationResponseType formatType = ValidationResponseType.valueOf((String)Objects.requireNonNull(format).toUpperCase(Locale.ENGLISH));
                webApplicationService.setFormat(formatType);
            }
        }
        catch (Exception e) {
            LOGGER.error("Format specified in the request [{}] is not recognized", (Object)format);
        }
        return webApplicationService;
    }

    public WebApplicationService createService(HttpServletRequest request) {
        String serviceToUse = this.getRequestedService(request);
        if (StringUtils.isBlank((CharSequence)serviceToUse)) {
            LOGGER.trace("No service is specified in the request. Skipping service creation");
            return null;
        }
        return this.newWebApplicationService(request, serviceToUse);
    }

    public WebApplicationService createService(String id) {
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        return this.newWebApplicationService(request, id);
    }

    protected WebApplicationService newWebApplicationService(HttpServletRequest request, String serviceToUse) {
        String artifactId = Optional.ofNullable(request).map(httpServletRequest -> httpServletRequest.getParameter("ticket")).orElse(null);
        String id = WebApplicationServiceFactory.cleanupUrl(serviceToUse);
        SimpleWebApplicationServiceImpl newService = new SimpleWebApplicationServiceImpl(id, serviceToUse, artifactId);
        WebApplicationServiceFactory.determineWebApplicationFormat(request, newService);
        String source = WebApplicationServiceFactory.getSourceParameter(request, "targetService", "service");
        newService.setSource(source);
        if (request != null) {
            this.populateAttributes((Service)newService, request);
            if (StringUtils.isNotBlank((CharSequence)source)) {
                newService.getAttributes().put(source, CollectionUtils.wrap((Object)id));
            }
        }
        return newService;
    }

    protected String getRequestedService(HttpServletRequest request) {
        String targetService = request.getParameter("targetService");
        String service = request.getParameter("service");
        Object serviceAttribute = request.getAttribute("service");
        if (StringUtils.isNotBlank((CharSequence)targetService)) {
            return targetService;
        }
        if (StringUtils.isNotBlank((CharSequence)service)) {
            return service;
        }
        if (serviceAttribute != null) {
            if (serviceAttribute instanceof Service) {
                Service svc = (Service)serviceAttribute;
                return svc.getId();
            }
            return serviceAttribute.toString();
        }
        return null;
    }
}

