/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.mgmt;

import com.github.benmanes.caffeine.cache.Cache;
import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.AttributeIndex;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.resultset.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.query.RegisteredServiceQuery;
import org.apereo.cas.services.query.RegisteredServiceQueryAttribute;
import org.apereo.cas.services.query.RegisteredServiceQueryIndex;
import org.apereo.cas.support.events.service.CasRegisteredServiceDeletedEvent;
import org.apereo.cas.support.events.service.CasRegisteredServiceExpiredEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicePreDeleteEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicePreSaveEvent;
import org.apereo.cas.support.events.service.CasRegisteredServiceSavedEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesDeletedEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesLoadedEvent;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractServicesManager
implements ServicesManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServicesManager.class);
    protected final ServicesManagerConfigurationContext configurationContext;
    private final CasReentrantLock lock = new CasReentrantLock();
    private final IndexedCollection<RegisteredService> indexedRegisteredServices;

    protected AbstractServicesManager(ServicesManagerConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        this.indexedRegisteredServices = new ConcurrentIndexedCollection();
        configurationContext.getRegisteredServiceLocators().forEach(locator -> locator.getRegisteredServiceIndexes().stream().map(RegisteredServiceQueryIndex::getIndex).filter(AttributeIndex.class::isInstance).map(AttributeIndex.class::cast).forEach(index -> {
            LOGGER.debug("Adding registered service index [{}] supplied by [{}]", (Object)index.getAttribute().toString(), (Object)locator.getClass().getSimpleName());
            this.indexedRegisteredServices.addIndex((Index)index);
        }));
    }

    private static Predicate<RegisteredService> getRegisteredServicesFilteringPredicate(Predicate<RegisteredService> ... p) {
        ArrayList predicates = Stream.of(p).collect(Collectors.toCollection(ArrayList::new));
        return predicates.stream().reduce(x -> true, Predicate::and);
    }

    public void save(Stream<RegisteredService> toSave) {
        toSave.forEach(this::save);
    }

    public RegisteredService save(RegisteredService registeredService) {
        return this.save(registeredService, true);
    }

    public RegisteredService save(RegisteredService registeredService, boolean publishEvent) {
        return (RegisteredService)this.lock.tryLock(() -> {
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            this.publishEvent((ApplicationEvent)new CasRegisteredServicePreSaveEvent((Object)this, registeredService, clientInfo));
            RegisteredService savedService = this.configurationContext.getServiceRegistry().save(registeredService);
            this.cacheRegisteredService(savedService);
            this.saveInternal(registeredService);
            if (publishEvent) {
                this.publishEvent((ApplicationEvent)new CasRegisteredServiceSavedEvent((Object)this, savedService, clientInfo));
            }
            return savedService;
        });
    }

    public void save(Supplier<RegisteredService> supplier, Consumer<RegisteredService> andThenConsume, long countExclusive) {
        this.configurationContext.getServiceRegistry().save(() -> {
            RegisteredService registeredService = (RegisteredService)supplier.get();
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            if (registeredService != null) {
                this.publishEvent((ApplicationEvent)new CasRegisteredServicePreSaveEvent((Object)this, registeredService, clientInfo));
                this.cacheRegisteredService(registeredService);
                this.saveInternal(registeredService);
                this.publishEvent((ApplicationEvent)new CasRegisteredServiceSavedEvent((Object)this, registeredService, clientInfo));
                return registeredService;
            }
            return null;
        }, andThenConsume, countExclusive);
    }

    public void deleteAll() {
        this.lock.tryLock(__ -> {
            this.configurationContext.getServicesCache().asMap().forEach((k, v) -> this.delete((RegisteredService)v));
            this.configurationContext.getServicesCache().invalidateAll();
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            this.publishEvent((ApplicationEvent)new CasRegisteredServicesDeletedEvent((Object)this, clientInfo));
        });
    }

    public RegisteredService delete(long id) {
        return (RegisteredService)this.lock.tryLock(() -> {
            RegisteredService service = this.findServiceBy(id);
            return this.delete(service);
        });
    }

    public RegisteredService delete(RegisteredService service) {
        return (RegisteredService)this.lock.tryLock(() -> {
            if (service != null) {
                ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
                this.publishEvent((ApplicationEvent)new CasRegisteredServicePreDeleteEvent((Object)this, service, clientInfo));
                this.configurationContext.getServiceRegistry().delete(service);
                this.configurationContext.getServicesCache().invalidate((Object)service.getId());
                this.deleteInternal(service);
                this.publishEvent((ApplicationEvent)new CasRegisteredServiceDeletedEvent((Object)this, service, clientInfo));
            }
            return service;
        });
    }

    public RegisteredService findServiceBy(Service service) {
        if (service == null) {
            return null;
        }
        Collection<RegisteredService> candidates = this.getCandidateServicesToMatch(service.getId());
        Optional foundService = this.configurationContext.getRegisteredServiceLocators().stream().map(locator -> locator.locate(candidates, service)).filter(registeredService -> this.validateRegisteredService((RegisteredService)registeredService) != null).findFirst();
        if (foundService.isEmpty()) {
            ServiceRegistry serviceRegistry = this.configurationContext.getServiceRegistry();
            LOGGER.trace("Service [{}] is not cached; Searching [{}]", (Object)service.getId(), (Object)serviceRegistry.getName());
            foundService = Optional.ofNullable(serviceRegistry.findServiceBy(service.getId()));
            if (foundService.isPresent()) {
                RegisteredService registeredService2 = foundService.get();
                foundService = this.configurationContext.getRegisteredServiceLocators().stream().filter(locator -> locator.supports(registeredService2, service)).findFirst().map(locator -> {
                    LOGGER.debug("Service [{}] is found in service registry and can be supported by [{}]", (Object)registeredService2, (Object)locator.getName());
                    this.cacheRegisteredService(registeredService2);
                    LOGGER.trace("Service [{}] is now cached from [{}]", (Object)service, (Object)serviceRegistry.getName());
                    return Optional.of(registeredService2);
                }).orElseGet(Optional::empty);
            }
        }
        foundService.ifPresent(RegisteredService::initialize);
        return this.validateRegisteredService(foundService.orElse(null));
    }

    public Collection<RegisteredService> findServiceBy(Predicate<RegisteredService> predicate) {
        if (predicate == null) {
            return new ArrayList<RegisteredService>(0);
        }
        Map results = this.configurationContext.getServiceRegistry().findServicePredicate(predicate).stream().sorted().peek(RegisteredService::initialize).collect(Collectors.toMap(RegisteredServiceDefinition::getId, Function.identity(), (r, s) -> s));
        this.configurationContext.getServicesCache().putAll(results);
        return results.values();
    }

    public <T extends RegisteredService> T findServiceBy(Service requestedService, Class<T> clazz) {
        if (requestedService == null) {
            return null;
        }
        RegisteredService service = this.findServiceBy(requestedService);
        if (service != null && clazz.isAssignableFrom(service.getClass())) {
            return (T)service;
        }
        return null;
    }

    public RegisteredService findServiceBy(long id) {
        RegisteredService result = (RegisteredService)this.configurationContext.getServicesCache().get((Object)id, __ -> this.configurationContext.getServiceRegistry().findServiceById(id));
        return this.validateRegisteredService(result);
    }

    public <T extends RegisteredService> T findServiceBy(long id, Class<T> clazz) {
        RegisteredService service = this.getService(registeredService -> registeredService.getId() == id);
        if (service != null && clazz.isAssignableFrom(service.getClass())) {
            return (T)service;
        }
        LOGGER.trace("The service with id [{}] and type [{}] is not found in the cache; trying to find it from [{}]", new Object[]{id, clazz, this.configurationContext.getServiceRegistry().getName()});
        service = (RegisteredService)this.configurationContext.getServicesCache().get((Object)id, __ -> this.configurationContext.getServiceRegistry().findServiceById(id, clazz));
        return (T)this.validateRegisteredService(service);
    }

    public RegisteredService findServiceByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        RegisteredService service = this.getService(registeredService -> registeredService.getName().equals(name));
        if (service == null) {
            ServiceRegistry registry = this.configurationContext.getServiceRegistry();
            LOGGER.trace("The service with name [{}] is not found in the cache; trying to find it from [{}]", (Object)name, (Object)registry.getName());
            service = registry.findServiceByExactServiceName(name);
            if (service != null) {
                this.cacheRegisteredService(service);
                LOGGER.trace("The service is found in [{}] and populated to the cache [{}]", (Object)registry.getName(), (Object)service);
            }
        }
        if (service != null) {
            service.initialize();
        }
        return this.validateRegisteredService(service);
    }

    public <T extends RegisteredService> T findServiceByName(String name, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        RegisteredService service = this.getService(registeredService -> registeredService.getName().equals(name));
        if (service != null && clazz.isAssignableFrom(service.getClass())) {
            return (T)service;
        }
        LOGGER.trace("The service with name [{}] and type [{}] is not found in the cache; trying to find it from [{}]", new Object[]{name, clazz, this.configurationContext.getServiceRegistry().getName()});
        service = this.configurationContext.getServiceRegistry().findServiceByExactServiceName(name, clazz);
        if (service != null) {
            this.cacheRegisteredService(service);
            LOGGER.trace("The service is found in [{}] and populated to the cache [{}]", (Object)this.configurationContext.getServiceRegistry().getName(), (Object)service);
        }
        return (T)this.validateRegisteredService(service);
    }

    public Collection<RegisteredService> getAllServices() {
        return this.getCacheableServicesStream().get().filter(this::validateAndFilterServiceByEnvironment).filter(AbstractServicesManager.getRegisteredServicesFilteringPredicate(new Predicate[0])).sorted().peek(RegisteredService::initialize).peek(this::cacheRegisteredService).collect(Collectors.toList());
    }

    public Collection<RegisteredService> getAllServicesOfType(Class clazz) {
        if (this.supports(clazz)) {
            return this.getCacheableServicesStream().get().filter(service -> clazz.isAssignableFrom(service.getClass())).filter(this::validateAndFilterServiceByEnvironment).filter(AbstractServicesManager.getRegisteredServicesFilteringPredicate(new Predicate[0])).sorted().peek(RegisteredService::initialize).peek(this::cacheRegisteredService).collect(Collectors.toList());
        }
        return new ArrayList<RegisteredService>();
    }

    public Stream<? extends RegisteredService> stream() {
        return this.configurationContext.getServiceRegistry().getServicesStream();
    }

    public Collection<RegisteredService> load() {
        return (Collection)this.lock.tryLock(() -> {
            LOGGER.trace("Loading services from [{}]", (Object)this.configurationContext.getServiceRegistry().getName());
            Map<Long, RegisteredService> servicesMap = this.configurationContext.getServiceRegistry().load().stream().filter(arg_0 -> ((AbstractServicesManager)this).supports(arg_0)).filter(this::validateAndFilterServiceByEnvironment).peek(this::loadInternal).filter(Objects::nonNull).map(this::applyTemplate).filter(Objects::nonNull).collect(Collectors.toMap(service -> {
                LOGGER.trace("Adding registered service [{}] with name [{}] and internal identifier [{}]", new Object[]{service.getServiceId(), service.getName(), service.getId()});
                return service.getId();
            }, Function.identity(), (__, service) -> service));
            this.cacheRegisteredServices(servicesMap);
            this.loadInternal();
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            this.publishEvent((ApplicationEvent)new CasRegisteredServicesLoadedEvent((Object)this, this.getAllServices(), clientInfo));
            this.evaluateExpiredServiceDefinitions();
            ConcurrentMap results = this.configurationContext.getServicesCache().asMap();
            LOGGER.info("Loaded [{}] service(s) from [{}].", (Object)results.size(), (Object)this.configurationContext.getServiceRegistry().getName());
            return results.values();
        });
    }

    private Map<Long, RegisteredService> cacheRegisteredServices(Map<Long, RegisteredService> servicesMap) {
        Cache<Long, RegisteredService> servicesCache = this.configurationContext.getServicesCache();
        servicesCache.invalidateAll();
        servicesCache.putAll(servicesMap);
        this.indexedRegisteredServices.addAll(servicesMap.values());
        return servicesCache.asMap();
    }

    public long count() {
        return this.configurationContext.getServiceRegistry().size();
    }

    public Stream<RegisteredService> findServicesBy(RegisteredServiceQuery ... queries) {
        List<Query> serviceQueries = Arrays.stream(queries).map(RegisteredServiceQueryAttribute::new).map(RegisteredServiceQueryAttribute::toQuery).toList();
        if (serviceQueries.isEmpty()) {
            return Stream.empty();
        }
        if (serviceQueries.size() == 1) {
            try (ResultSet results = this.indexedRegisteredServices.retrieve(serviceQueries.getFirst());){
                Stream stream = results.stream();
                return stream;
            }
        }
        List<Query> subQueries = serviceQueries.subList(2, serviceQueries.size());
        And query = QueryFactory.and((Query)serviceQueries.getFirst(), (Query)serviceQueries.get(1), subQueries);
        try (ResultSet results = this.indexedRegisteredServices.retrieve((Query)query);){
            Stream stream = results.stream();
            return stream;
        }
    }

    protected abstract Collection<RegisteredService> getCandidateServicesToMatch(String var1);

    protected void deleteInternal(RegisteredService service) {
    }

    protected void saveInternal(RegisteredService service) {
    }

    protected void loadInternal() {
    }

    protected void loadInternal(RegisteredService service) {
    }

    protected RegisteredService applyTemplate(RegisteredService service) {
        return this.configurationContext.getRegisteredServicesTemplatesManager().apply(service);
    }

    protected Supplier<Stream<RegisteredService>> getCacheableServicesStream() {
        this.configurationContext.getServicesCache().cleanUp();
        long size = this.configurationContext.getServicesCache().estimatedSize();
        if (size <= 0L) {
            return () -> this.configurationContext.getServiceRegistry().getServicesStream();
        }
        return () -> this.configurationContext.getServicesCache().asMap().values().stream();
    }

    private void cacheRegisteredService(RegisteredService service) {
        if (this.configurationContext.getServicesCache().getIfPresent((Object)service.getId()) == null) {
            this.configurationContext.getServicesCache().put((Object)service.getId(), (Object)service);
            this.indexedRegisteredServices.add((Object)service);
        }
    }

    private void evaluateExpiredServiceDefinitions() {
        this.getCacheableServicesStream().get().filter(RegisteredServiceAccessStrategyUtils.getRegisteredServiceExpirationPolicyPredicate().negate()).forEach(this::processExpiredRegisteredService);
    }

    private RegisteredService validateRegisteredService(RegisteredService registeredService) {
        RegisteredService result = this.checkServiceExpirationPolicyIfAny(registeredService);
        if (this.validateAndFilterServiceByEnvironment(result)) {
            return result;
        }
        return null;
    }

    private RegisteredService checkServiceExpirationPolicyIfAny(RegisteredService registeredService) {
        if (registeredService == null || RegisteredServiceAccessStrategyUtils.ensureServiceIsNotExpired((RegisteredService)registeredService)) {
            return registeredService;
        }
        return this.processExpiredRegisteredService(registeredService);
    }

    private RegisteredService processExpiredRegisteredService(RegisteredService registeredService) {
        RegisteredServiceExpirationPolicy policy = registeredService.getExpirationPolicy();
        LOGGER.warn("Registered service [{}] has expired on [{}]", (Object)registeredService.getServiceId(), (Object)policy.getExpirationDate());
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (policy.isNotifyWhenExpired()) {
            LOGGER.debug("Contacts for registered service [{}] will be notified of service expiry", (Object)registeredService.getServiceId());
            this.publishEvent((ApplicationEvent)new CasRegisteredServiceExpiredEvent((Object)this, registeredService, false, clientInfo));
        }
        if (policy.isDeleteWhenExpired()) {
            LOGGER.debug("Deleting expired registered service [{}] from registry.", (Object)registeredService.getServiceId());
            if (policy.isNotifyWhenDeleted()) {
                LOGGER.debug("Contacts for registered service [{}] will be notified of service expiry and removal", (Object)registeredService.getServiceId());
                this.publishEvent((ApplicationEvent)new CasRegisteredServiceExpiredEvent((Object)this, registeredService, true, clientInfo));
            }
            this.delete(registeredService);
            return null;
        }
        return registeredService;
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.configurationContext.getApplicationContext() != null) {
            this.configurationContext.getApplicationContext().publishEvent(event);
        }
    }

    private boolean validateAndFilterServiceByEnvironment(RegisteredService service) {
        if (this.configurationContext.getEnvironments().isEmpty()) {
            LOGGER.trace("No environments are defined by which services could be filtered");
            return true;
        }
        if (service == null) {
            LOGGER.trace("No service definition was provided");
            return true;
        }
        if (service.getEnvironments() == null || service.getEnvironments().isEmpty()) {
            LOGGER.trace("No environments are assigned to service [{}]", (Object)service.getName());
            return true;
        }
        return service.getEnvironments().stream().anyMatch(this.configurationContext.getEnvironments()::contains);
    }

    private RegisteredService getService(Predicate<RegisteredService> filter) {
        return this.getCacheableServicesStream().get().filter(filter).findFirst().orElse(null);
    }

    @Generated
    public ServicesManagerConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    @Generated
    public CasReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public IndexedCollection<RegisteredService> getIndexedRegisteredServices() {
        return this.indexedRegisteredServices;
    }
}

