/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.services.json.JsonServiceRegistryProperties;
import org.apereo.cas.services.ChainingServiceRegistry;
import org.apereo.cas.services.DefaultServiceRegistryInitializer;
import org.apereo.cas.services.DefaultServiceRegistryInitializerEventListener;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryInitializer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.resource.AbstractResourceBasedServiceRegistry;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.CasEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration(value="CasServiceRegistryInitializationConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnMissingClass(value={"org.apereo.cas.services.JsonServiceRegistry", "org.apereo.cas.services.YamlServiceRegistry"})
@ConditionalOnBean(value={ServicesManager.class})
@ConditionalOnProperty(prefix="cas.service-registry.core", name={"init-from-json"}, havingValue="true")
@EnableAspectJAutoProxy
@EnableAsync
@AutoConfigureAfter(value={CasCoreServicesConfiguration.class})
public class CasServiceRegistryInitializationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasServiceRegistryInitializationConfiguration.class);

    public static class EmbeddedResourceBasedServiceRegistry
    extends AbstractResourceBasedServiceRegistry {
        EmbeddedResourceBasedServiceRegistry(ConfigurableApplicationContext applicationContext, Resource location, Collection<ServiceRegistryListener> serviceRegistryListeners, WatcherService watcherService) throws Exception {
            super(location, EmbeddedResourceBasedServiceRegistry.getRegisteredServiceSerializers(), applicationContext, serviceRegistryListeners, watcherService);
        }

        static Collection<StringSerializer<RegisteredService>> getRegisteredServiceSerializers() {
            return CollectionUtils.wrapList((Object[])new StringSerializer[]{new RegisteredServiceJsonSerializer()});
        }

        protected String[] getExtensions() {
            return new String[]{"json"};
        }
    }

    @Configuration(value="CasServiceRegistryEmbeddedConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasServiceRegistryEmbeddedConfiguration {
        private static Resource getServiceRegistryInitializerServicesDirectoryResource(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) throws Exception {
            JsonServiceRegistryProperties registry = casProperties.getServiceRegistry().getJson();
            if (ResourceUtils.doesResourceExist((Resource)registry.getLocation())) {
                LOGGER.debug("Using JSON service registry location [{}] for embedded service definitions", (Object)registry.getLocation());
                return registry.getLocation();
            }
            File parent = new File(FileUtils.getTempDirectory(), "cas");
            if (!parent.mkdirs()) {
                LOGGER.warn("Unable to create folder [{}]", (Object)parent);
            }
            Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)applicationContext).getResources("classpath*:/services/*.json");
            Arrays.stream(resources).forEach(resource -> ResourceUtils.exportClasspathResourceToFile((File)parent, (Resource)resource));
            LOGGER.debug("Using service registry location [{}] for embedded service definitions", (Object)parent);
            return new FileSystemResource(parent);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public ServiceRegistry embeddedJsonServiceRegistry(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<List<ServiceRegistryListener>> serviceRegistryListeners) throws Exception {
            Resource location = CasServiceRegistryEmbeddedConfiguration.getServiceRegistryInitializerServicesDirectoryResource(casProperties, applicationContext);
            EmbeddedResourceBasedServiceRegistry registry = new EmbeddedResourceBasedServiceRegistry(applicationContext, location, Optional.ofNullable((List)serviceRegistryListeners.getIfAvailable()).orElseGet(ArrayList::new), WatcherService.noOp());
            if (!(location instanceof ClassPathResource) && casProperties.getServiceRegistry().getJson().isWatcherEnabled()) {
                registry.enableDefaultWatcherService();
            }
            return registry;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"embeddedJsonServiceRegistryExecutionPlanConfigurer"})
        public ServiceRegistryExecutionPlanConfigurer embeddedJsonServiceRegistryExecutionPlanConfigurer(@Qualifier(value="embeddedJsonServiceRegistry") ServiceRegistry embeddedJsonServiceRegistry) {
            return plan -> plan.registerServiceRegistry(embeddedJsonServiceRegistry);
        }
    }

    @Configuration(value="CasServiceRegistryInitializationBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasServiceRegistryInitializationBaseConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceRegistryInitializer serviceRegistryInitializer(@Qualifier(value="embeddedJsonServiceRegistry") ServiceRegistry embeddedJsonServiceRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="serviceRegistry") ChainingServiceRegistry serviceRegistry) {
            return new DefaultServiceRegistryInitializer(embeddedJsonServiceRegistry, serviceRegistry, servicesManager);
        }
    }

    @Configuration(value="CasServiceRegistryInitializationEventsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasServiceRegistryInitializationEventsConfiguration {
        @Bean
        public CasEventListener serviceRegistryInitializerConfigurationEventListener(@Qualifier(value="serviceRegistryInitializer") ServiceRegistryInitializer serviceRegistryInitializer) {
            return new DefaultServiceRegistryInitializerEventListener(serviceRegistryInitializer);
        }
    }
}

