/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.queue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.queue.BaseMessageQueueCommand;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.PublisherIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class UpdateTicketMessageQueueCommand
extends BaseMessageQueueCommand {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateTicketMessageQueueCommand.class);
    private static final long serialVersionUID = -4179190682337040669L;
    @JsonProperty
    private Ticket ticket;

    @JsonCreator
    public UpdateTicketMessageQueueCommand(@JsonProperty(value="id") PublisherIdentifier id, @JsonProperty(value="ticket") Ticket ticket) {
        super(id);
        this.ticket = ticket;
    }

    @Override
    public void execute(TicketRegistry registry) throws Exception {
        LOGGER.debug("Executing queue command on ticket registry id [{}] to update ticket [{}]", (Object)this.getId().getId(), (Object)this.ticket);
        registry.updateTicket(this.ticket);
    }

    @Generated
    public Ticket getTicket() {
        return this.ticket;
    }
}

