/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.TicketValidator;

public class InternalTicketValidator
implements TicketValidator {
    private final CentralAuthenticationService centralAuthenticationService;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    private final AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;
    private final ServicesManager servicesManager;

    public Assertion validate(String ticketId, String serviceId) {
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(serviceId);
        org.apereo.cas.validation.Assertion assertion = this.centralAuthenticationService.validateServiceTicket(ticketId, (Service)service);
        Authentication authentication = assertion.getPrimaryAuthentication();
        Principal principal = authentication.getPrincipal();
        AttributePrincipalImpl attrPrincipal = new AttributePrincipalImpl(principal.getId(), principal.getAttributes());
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        Map authenticationAttributes = this.authenticationAttributeReleasePolicy.getAuthenticationAttributesForRelease(authentication, assertion, new HashMap(0), registeredService);
        return new AssertionImpl((AttributePrincipal)attrPrincipal, authenticationAttributes);
    }

    @Generated
    public InternalTicketValidator(CentralAuthenticationService centralAuthenticationService, ServiceFactory<WebApplicationService> webApplicationServiceFactory, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, ServicesManager servicesManager) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.authenticationAttributeReleasePolicy = authenticationAttributeReleasePolicy;
        this.servicesManager = servicesManager;
    }
}

