/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.PropertiesAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractTicket
implements TicketGrantingTicketAwareTicket,
PropertiesAwareTicket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTicket.class);
    private static final long serialVersionUID = -8506442397878267555L;
    private ExpirationPolicy expirationPolicy;
    private String id;
    private ZonedDateTime lastTimeUsed;
    private ZonedDateTime previousTimeUsed;
    private ZonedDateTime creationTime;
    private int countOfUses;
    private Boolean expired = Boolean.FALSE;
    private Boolean stateless = Boolean.FALSE;
    private Map<String, Object> properties = new HashMap<String, Object>(0);

    protected AbstractTicket(String id, ExpirationPolicy expirationPolicy) {
        this.id = id;
        this.lastTimeUsed = this.creationTime = ZonedDateTime.now(expirationPolicy.getClock());
        this.expirationPolicy = expirationPolicy;
    }

    public boolean isExpired() {
        return this.expirationPolicy.isExpired((TicketGrantingTicketAwareTicket)this) || this.isExpiredInternal();
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public void markTicketExpired() {
        this.expired = Boolean.TRUE;
    }

    @CanIgnoreReturnValue
    public Ticket markTicketStateless() {
        this.stateless = Boolean.TRUE;
        return this;
    }

    public void update() {
        this.updateTicketState();
        this.updateTicketGrantingTicketState();
    }

    public int compareTo(Ticket o) {
        return this.getId().compareTo(o.getId());
    }

    public String toString() {
        return this.getId();
    }

    public Authentication getAuthentication() {
        Ticket ticketGrantingTicket = this.getTicketGrantingTicket();
        return Optional.ofNullable(ticketGrantingTicket).map(AuthenticationAwareTicket.class::cast).map(AuthenticationAwareTicket::getAuthentication).orElse(null);
    }

    public Ticket getTicketGrantingTicket() {
        return null;
    }

    protected void updateTicketGrantingTicketState() {
        Ticket ticketGrantingTicket = this.getTicketGrantingTicket();
        if (ticketGrantingTicket != null && !ticketGrantingTicket.isExpired()) {
            ticketGrantingTicket.update();
        }
    }

    protected void updateTicketState() {
        LOGGER.trace("Before updating ticket [{}]\n\tPrevious time used: [{}]\n\tLast time used: [{}]\n\tUsage count: [{}]", new Object[]{this.getId(), this.previousTimeUsed, this.lastTimeUsed, this.countOfUses});
        this.previousTimeUsed = ZonedDateTime.from(this.lastTimeUsed);
        this.lastTimeUsed = ZonedDateTime.now(this.expirationPolicy.getClock());
        ++this.countOfUses;
        LOGGER.trace("After updating ticket [{}]\n\tPrevious time used: [{}]\n\tLast time used: [{}]\n\tUsage count: [{}]", new Object[]{this.getId(), this.previousTimeUsed, this.lastTimeUsed, this.countOfUses});
    }

    @JsonIgnore
    protected boolean isExpiredInternal() {
        return this.expired;
    }

    public void putProperty(String name, Serializable value) {
        this.properties.put(name, value);
    }

    public void putAllProperties(Map<String, Serializable> props) {
        this.properties.putAll(props);
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public <T> T getProperty(String name, Class<T> clazz) {
        if (this.containsProperty(name)) {
            return clazz.cast(this.properties.get(name));
        }
        return null;
    }

    public <T extends Serializable> T getProperty(String name, Class<T> clazz, T defaultValue) {
        if (this.containsProperty(name)) {
            return (T)((Serializable)clazz.cast(this.properties.getOrDefault(name, defaultValue)));
        }
        return defaultValue;
    }

    @Generated
    protected AbstractTicket() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTicket)) {
            return false;
        }
        AbstractTicket other = (AbstractTicket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTicket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastTimeUsed(ZonedDateTime lastTimeUsed) {
        this.lastTimeUsed = lastTimeUsed;
    }

    @Generated
    public void setPreviousTimeUsed(ZonedDateTime previousTimeUsed) {
        this.previousTimeUsed = previousTimeUsed;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setCountOfUses(int countOfUses) {
        this.countOfUses = countOfUses;
    }

    @Generated
    public void setExpired(Boolean expired) {
        this.expired = expired;
    }

    @Generated
    public void setStateless(Boolean stateless) {
        this.stateless = stateless;
    }

    @Generated
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Generated
    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ZonedDateTime getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    @Generated
    public ZonedDateTime getPreviousTimeUsed() {
        return this.previousTimeUsed;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public int getCountOfUses() {
        return this.countOfUses;
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

