/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.expiration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.expiration.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class TimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutExpirationPolicy.class);
    private static final long MAX_EXPIRATION_IN_YEARS = 50L;
    private static final long serialVersionUID = -7636642464326939536L;
    private long timeToKillInSeconds;

    @JsonCreator
    public TimeoutExpirationPolicy(@JsonProperty(value="timeToIdle") long timeToKillInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
    }

    @Override
    public boolean isExpired(TicketGrantingTicketAwareTicket ticketState) {
        boolean result;
        ZonedDateTime expirationTime;
        if (ticketState == null) {
            return true;
        }
        ZonedDateTime now = ZonedDateTime.now(this.getClock());
        boolean expired = now.isAfter(expirationTime = this.getIdleExpirationTime((Ticket)ticketState));
        boolean bl = result = expired || super.isExpired(ticketState);
        if (result) {
            LOGGER.trace("Ticket [{}] is expired because its expiration time [{}] is after [{}] or its parent ticket, if any, has expired", new Object[]{ticketState.getId(), expirationTime, now});
        }
        return result;
    }

    @JsonIgnore
    public Long getTimeToLive() {
        return Long.MAX_VALUE;
    }

    public Long getTimeToIdle() {
        return this.timeToKillInSeconds;
    }

    @JsonIgnore
    public ZonedDateTime getIdleExpirationTime(Ticket ticketState) {
        ZonedDateTime lastTimeUsed = ticketState.getLastTimeUsed();
        return lastTimeUsed.plus(this.timeToKillInSeconds, ChronoUnit.SECONDS);
    }

    public ZonedDateTime toMaximumExpirationTime(Ticket ticketState) {
        return ZonedDateTime.now(Clock.systemUTC()).plusYears(50L);
    }

    @Generated
    public static TimeoutExpirationPolicyBuilder builder() {
        return new TimeoutExpirationPolicyBuilder();
    }

    @Generated
    public TimeoutExpirationPolicy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeoutExpirationPolicy)) {
            return false;
        }
        TimeoutExpirationPolicy other = (TimeoutExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.timeToKillInSeconds == other.timeToKillInSeconds;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeoutExpirationPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TimeoutExpirationPolicy(super=" + super.toString() + ", timeToKillInSeconds=" + this.timeToKillInSeconds + ")";
    }

    @Generated
    public static class TimeoutExpirationPolicyBuilder {
        @Generated
        private long timeToKillInSeconds;

        @Generated
        TimeoutExpirationPolicyBuilder() {
        }

        @Generated
        public TimeoutExpirationPolicyBuilder timeToKillInSeconds(long timeToKillInSeconds) {
            this.timeToKillInSeconds = timeToKillInSeconds;
            return this;
        }

        @Generated
        public TimeoutExpirationPolicy build() {
            return new TimeoutExpirationPolicy(this.timeToKillInSeconds);
        }

        @Generated
        public String toString() {
            return "TimeoutExpirationPolicy.TimeoutExpirationPolicyBuilder(timeToKillInSeconds=" + this.timeToKillInSeconds + ")";
        }
    }
}

