/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.apereo.cas.ticket.registry.pubsub.QueueableTicketRegistry;
import org.apereo.cas.ticket.registry.pubsub.commands.AddTicketMessageQueueCommand;
import org.apereo.cas.ticket.registry.pubsub.commands.DeleteTicketMessageQueueCommand;
import org.apereo.cas.ticket.registry.pubsub.commands.DeleteTicketsMessageQueueCommand;
import org.apereo.cas.ticket.registry.pubsub.commands.UpdateTicketMessageQueueCommand;
import org.apereo.cas.ticket.registry.pubsub.queue.QueueableTicketRegistryMessagePublisher;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.apereo.cas.util.PublisherIdentifier;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapBasedTicketRegistry
extends AbstractTicketRegistry
implements QueueableTicketRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMapBasedTicketRegistry.class);
    protected final QueueableTicketRegistryMessagePublisher ticketPublisher;
    protected final PublisherIdentifier publisherIdentifier;

    public AbstractMapBasedTicketRegistry(CipherExecutor cipherExecutor, TicketSerializationManager ticketSerializationManager, TicketCatalog ticketCatalog, QueueableTicketRegistryMessagePublisher ticketPublisher, PublisherIdentifier publisherIdentifier) {
        super(cipherExecutor, ticketSerializationManager, ticketCatalog);
        this.ticketPublisher = ticketPublisher;
        this.publisherIdentifier = publisherIdentifier;
    }

    public Ticket getTicket(String ticketId, Predicate<Ticket> predicate) {
        String encTicketId = this.digestIdentifier(ticketId);
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            return null;
        }
        Ticket found = this.getMapInstance().get(encTicketId);
        if (found == null) {
            LOGGER.debug("Ticket [{}] could not be found", (Object)encTicketId);
            return null;
        }
        Ticket result = this.decodeTicket(found);
        if (!predicate.test(result)) {
            LOGGER.debug("Cannot successfully fetch ticket [{}]", (Object)ticketId);
            return null;
        }
        return result;
    }

    public long deleteAll() {
        long result = this.deleteAllFromQueue();
        if (this.ticketPublisher.isEnabled()) {
            this.ticketPublisher.publishMessageToQueue(new DeleteTicketsMessageQueueCommand(this.publisherIdentifier));
        }
        return result;
    }

    public Collection<? extends Ticket> getTickets() {
        return this.decodeTickets(this.getMapInstance().values());
    }

    public Ticket updateTicket(Ticket ticket) throws Exception {
        Ticket result = this.updateTicketInQueue(ticket);
        if (this.ticketPublisher.isEnabled()) {
            LOGGER.trace("Publishing update command for id [{}] and ticket [{}]", (Object)this.publisherIdentifier, (Object)ticket.getId());
            UpdateTicketMessageQueueCommand command = new UpdateTicketMessageQueueCommand(this.publisherIdentifier, ticket);
            this.ticketPublisher.publishMessageToQueue(command);
        }
        return result;
    }

    @Override
    public long deleteSingleTicket(Ticket ticket) {
        long result;
        long l = result = ticket != null ? this.deleteTicketFromQueue(ticket.getId()) : 0L;
        if (this.ticketPublisher.isEnabled()) {
            LOGGER.trace("Publishing delete command for id [{}] and ticket [{}]", (Object)this.publisherIdentifier, (Object)ticket.getId());
            this.ticketPublisher.publishMessageToQueue(new DeleteTicketMessageQueueCommand(this.publisherIdentifier, ticket.getId()));
        }
        return result;
    }

    @Override
    public Ticket addSingleTicket(Ticket ticket) throws Exception {
        this.addTicketToQueue(ticket);
        if (this.ticketPublisher.isEnabled()) {
            LOGGER.trace("Publishing add command for id [{}] and ticket [{}]", (Object)this.publisherIdentifier, (Object)ticket.getId());
            AddTicketMessageQueueCommand command = new AddTicketMessageQueueCommand(this.publisherIdentifier, ticket);
            this.ticketPublisher.publishMessageToQueue(command);
        }
        return ticket;
    }

    @Override
    public void addTicketToQueue(Ticket ticket) throws Exception {
        Ticket encTicket = this.encodeTicket(ticket);
        LOGGER.debug("Putting ticket [{}] in registry.", (Object)ticket.getId());
        this.getMapInstance().put(encTicket.getId(), encTicket);
    }

    @Override
    public Ticket updateTicketInQueue(Ticket ticket) throws Exception {
        LOGGER.trace("Updating ticket [{}] in registry...", (Object)ticket.getId());
        this.addTicket(ticket);
        return ticket;
    }

    @Override
    public long deleteTicketFromQueue(String ticketId) {
        String encTicketId = this.digestIdentifier(ticketId);
        return !StringUtils.isBlank((CharSequence)encTicketId) && this.getMapInstance().remove(encTicketId) != null ? 1L : 0L;
    }

    @Override
    public long deleteAllFromQueue() {
        int size = this.getMapInstance().size();
        this.getMapInstance().clear();
        return size;
    }

    public abstract Map<String, Ticket> getMapInstance();
}

