/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.tracking;

import lombok.Generated;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.apereo.cas.util.concurrent.CasReentrantLock;

public class AllServicesSessionTrackingPolicy
implements TicketTrackingPolicy {
    protected final TicketRegistry ticketRegistry;
    private final CasReentrantLock lock = new CasReentrantLock();

    public String trackTicket(Ticket ownerTicket, Ticket ticket) {
        ServiceTicket serviceTicket = (ServiceTicket)ticket;
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)ownerTicket;
        String trackedEntry = String.format("%s,%s", serviceTicket.getId(), serviceTicket.getService());
        this.lock.tryLock(__ -> {
            ownerTicket.update();
            serviceTicket.getService().setPrincipal(ticketGrantingTicket.getRoot().getAuthentication().getPrincipal().getId());
            this.beforeTrackingServiceTicket(ownerTicket, serviceTicket);
            ticketGrantingTicket.getServices().put(serviceTicket.getId(), serviceTicket.getService());
        });
        return trackedEntry;
    }

    protected void beforeTrackingServiceTicket(Ticket ownerTicket, ServiceTicket serviceTicket) {
    }

    @Generated
    public AllServicesSessionTrackingPolicy(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

