/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.ConnectionBackoffStrategy;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.DefaultBackoffStrategy;
import org.apache.hc.client5.http.impl.classic.FutureRequestExecutionService;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apereo.cas.util.http.HttpClientFactory;
import org.apereo.cas.util.http.SimpleHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpClientFactoryBean
implements HttpClientFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClientFactoryBean.class);
    public static final int MAX_CONNECTIONS_PER_ROUTE = 50;
    private static final int MAX_POOLED_CONNECTIONS = 100;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int TERMINATION_TIMEOUT_SECONDS = 5;
    private static final int[] DEFAULT_ACCEPTABLE_CODES = new int[]{200, 304, 302, 301, 202, 204};
    private int maxPooledConnections = 100;
    private int maxConnectionsPerRoute = 50;
    private List<Integer> acceptableCodes = IntStream.of(DEFAULT_ACCEPTABLE_CODES).boxed().toList();
    private long connectionTimeout = 5000L;
    private long socketTimeout = 5000L;
    private long responseTimeout = 5000L;
    private RedirectStrategy redirectionStrategy = new DefaultRedirectStrategy();
    private LayeredConnectionSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
    private SSLContext sslContext;
    private TrustManager[] trustManagers;
    private CredentialsProvider credentialsProvider;
    private CookieStore cookieStore;
    private ConnectionReuseStrategy connectionReuseStrategy = new DefaultConnectionReuseStrategy();
    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy = new DefaultConnectionKeepAliveStrategy();
    private ConnectionBackoffStrategy connectionBackoffStrategy = new DefaultBackoffStrategy();
    private HttpRequestRetryStrategy retryStrategy = new DefaultHttpRequestRetryStrategy();
    private Collection<? extends Header> defaultHeaders = new ArrayList<Header>(0);
    private AuthenticationStrategy proxyAuthenticationStrategy = new DefaultAuthenticationStrategy();
    private boolean circularRedirectsAllowed = true;
    private boolean authenticationEnabled;
    private boolean redirectsEnabled = true;
    private ExecutorService executorService;
    private HttpHost proxy;

    public SimpleHttpClient getObject() {
        CloseableHttpClient httpClient = this.buildHttpClient();
        FutureRequestExecutionService requestExecutorService = this.buildRequestExecutorService(httpClient);
        List<Integer> codes = this.acceptableCodes.stream().sorted().collect(Collectors.toList());
        return new SimpleHttpClient(codes, httpClient, requestExecutorService, this);
    }

    public Class<?> getObjectType() {
        return SimpleHttpClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void destroy() {
        if (this.executorService != null) {
            try {
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
            this.executorService = null;
        }
    }

    private CloseableHttpClient buildHttpClient() {
        LayeredConnectionSocketFactory sslFactory = Optional.ofNullable(this.sslSocketFactory).orElseGet(() -> new SSLConnectionSocketFactory((SSLContext)ObjectUtils.defaultIfNull((Object)this.sslContext, (Object)SSLContexts.createDefault()), (HostnameVerifier)ObjectUtils.defaultIfNull((Object)this.hostnameVerifier, (Object)new DefaultHostnameVerifier())));
        PlainConnectionSocketFactory plainSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainSocketFactory).register("https", (Object)sslFactory).build();
        ConnectionConfig connConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.connectionTimeout)).setSocketTimeout(Timeout.ofMilliseconds((long)this.socketTimeout)).setValidateAfterInactivity((TimeValue)Timeout.ofMilliseconds((long)5000L)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(this.maxPooledConnections);
        connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        connectionManager.setValidateAfterInactivity((TimeValue)Timeout.ofMilliseconds((long)5000L));
        connectionManager.setDefaultConnectionConfig(connConfig);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.connectionTimeout)).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)this.connectionTimeout)).setCircularRedirectsAllowed(this.circularRedirectsAllowed).setRedirectsEnabled(this.redirectsEnabled).setAuthenticationEnabled(this.authenticationEnabled).setResponseTimeout(Timeout.ofMilliseconds((long)this.responseTimeout)).build();
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).setRedirectStrategy(this.redirectionStrategy).setDefaultCredentialsProvider(this.credentialsProvider).setDefaultCookieStore(this.cookieStore).setConnectionReuseStrategy(this.connectionReuseStrategy).setKeepAliveStrategy(this.connectionKeepAliveStrategy).setConnectionBackoffStrategy(this.connectionBackoffStrategy).setRetryStrategy(this.retryStrategy).setProxyAuthenticationStrategy(this.proxyAuthenticationStrategy).setDefaultHeaders(this.defaultHeaders).setProxy(this.proxy).useSystemProperties();
        return builder.build();
    }

    private FutureRequestExecutionService buildRequestExecutorService(CloseableHttpClient httpClient) {
        if (this.executorService == null) {
            this.executorService = Executors.newVirtualThreadPerTaskExecutor();
        }
        return new FutureRequestExecutionService((HttpClient)httpClient, this.executorService);
    }

    @Generated
    public void setMaxPooledConnections(int maxPooledConnections) {
        this.maxPooledConnections = maxPooledConnections;
    }

    @Generated
    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    @Generated
    public void setAcceptableCodes(List<Integer> acceptableCodes) {
        this.acceptableCodes = acceptableCodes;
    }

    @Generated
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setSocketTimeout(long socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Generated
    public void setResponseTimeout(long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    @Generated
    public void setRedirectionStrategy(RedirectStrategy redirectionStrategy) {
        this.redirectionStrategy = redirectionStrategy;
    }

    @Generated
    public void setSslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @Generated
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @Generated
    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Generated
    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    @Generated
    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Generated
    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    @Generated
    public void setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.connectionReuseStrategy = connectionReuseStrategy;
    }

    @Generated
    public void setConnectionKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        this.connectionKeepAliveStrategy = connectionKeepAliveStrategy;
    }

    @Generated
    public void setConnectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.connectionBackoffStrategy = connectionBackoffStrategy;
    }

    @Generated
    public void setRetryStrategy(HttpRequestRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    @Generated
    public void setDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    @Generated
    public void setProxyAuthenticationStrategy(AuthenticationStrategy proxyAuthenticationStrategy) {
        this.proxyAuthenticationStrategy = proxyAuthenticationStrategy;
    }

    @Generated
    public void setCircularRedirectsAllowed(boolean circularRedirectsAllowed) {
        this.circularRedirectsAllowed = circularRedirectsAllowed;
    }

    @Generated
    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    @Generated
    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }

    @Generated
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Generated
    public void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }

    @Generated
    public int getMaxPooledConnections() {
        return this.maxPooledConnections;
    }

    @Generated
    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    @Generated
    public List<Integer> getAcceptableCodes() {
        return this.acceptableCodes;
    }

    @Override
    @Generated
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    @Generated
    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    @Generated
    public RedirectStrategy getRedirectionStrategy() {
        return this.redirectionStrategy;
    }

    @Override
    @Generated
    public LayeredConnectionSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    @Generated
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Override
    @Generated
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    @Generated
    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    @Generated
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Generated
    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    @Generated
    public ConnectionReuseStrategy getConnectionReuseStrategy() {
        return this.connectionReuseStrategy;
    }

    @Generated
    public ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        return this.connectionKeepAliveStrategy;
    }

    @Generated
    public ConnectionBackoffStrategy getConnectionBackoffStrategy() {
        return this.connectionBackoffStrategy;
    }

    @Generated
    public HttpRequestRetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    @Generated
    public Collection<? extends Header> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @Generated
    public AuthenticationStrategy getProxyAuthenticationStrategy() {
        return this.proxyAuthenticationStrategy;
    }

    @Generated
    public boolean isCircularRedirectsAllowed() {
        return this.circularRedirectsAllowed;
    }

    @Generated
    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    @Generated
    public boolean isRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    @Generated
    public HttpHost getProxy() {
        return this.proxy;
    }

    public static class DefaultHttpClient
    extends SimpleHttpClientFactoryBean {
    }
}

