/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import groovy.lang.GroovyObject;
import lombok.Generated;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.scripting.ExecutableCompiledGroovyScript;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class WatchableGroovyScriptResource
implements ExecutableCompiledGroovyScript {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchableGroovyScriptResource.class);
    private final CasReentrantLock lock = new CasReentrantLock();
    private final Resource resource;
    private FileWatcherService watcherService;
    private GroovyObject groovyScript;
    private boolean failOnError = true;

    public WatchableGroovyScriptResource(Resource script, boolean enableWatcher) {
        this.resource = script;
        if (ResourceUtils.doesResourceExist(script)) {
            if (ResourceUtils.isFile(script) && enableWatcher) {
                this.watcherService = (FileWatcherService)FunctionUtils.doUnchecked(() -> new FileWatcherService(script.getFile(), Unchecked.consumer(file -> {
                    LOGGER.debug("Reloading script at [{}]", file);
                    this.compileScriptResource(script);
                    LOGGER.info("Reloaded script at [{}]", file);
                })));
                this.watcherService.start(script.getFilename());
            }
            this.compileScriptResource(script);
        }
    }

    public WatchableGroovyScriptResource(Resource script) {
        this(script, true);
    }

    @Override
    public <T> T execute(Object[] args, Class<T> clazz) throws Throwable {
        return this.execute(args, clazz, this.failOnError);
    }

    @Override
    public void execute(Object[] args) throws Throwable {
        this.execute(args, Void.class, this.failOnError);
    }

    @Override
    public <T> T execute(String methodName, Class<T> clazz, Object ... args) throws Throwable {
        return this.execute(methodName, clazz, this.failOnError, args);
    }

    @Override
    public <T> T execute(Object[] args, Class<T> clazz, boolean failOnError) throws Throwable {
        return this.lock.tryLock(() -> {
            try {
                LOGGER.trace("Beginning to execute script [{}]", (Object)this);
                Object var4_4 = this.groovyScript != null ? ScriptingUtils.executeGroovyScript(this.groovyScript, args, clazz, failOnError) : null;
                return var4_4;
            }
            finally {
                LOGGER.trace("Completed script execution [{}]", (Object)this);
            }
        });
    }

    public <T> T execute(String methodName, Class<T> clazz, boolean failOnError, Object ... args) throws Throwable {
        return this.lock.tryLock(() -> {
            try {
                LOGGER.trace("Beginning to execute script [{}]", (Object)this);
                Object var5_5 = this.groovyScript != null ? ScriptingUtils.executeGroovyScript(this.groovyScript, methodName, args, clazz, failOnError) : null;
                return var5_5;
            }
            finally {
                LOGGER.trace("Completed script execution [{}]", (Object)this);
            }
        });
    }

    @Override
    public void close() {
        if (this.watcherService != null) {
            LOGGER.trace("Shutting down watcher service for [{}]", (Object)this.resource);
            this.watcherService.close();
        }
    }

    private void compileScriptResource(Resource script) {
        this.groovyScript = ScriptingUtils.parseGroovyScript(script, this.failOnError);
    }

    @Generated
    public CasReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public Resource getResource() {
        return this.resource;
    }

    @Generated
    public FileWatcherService getWatcherService() {
        return this.watcherService;
    }

    @Generated
    public GroovyObject getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public String toString() {
        return "WatchableGroovyScriptResource(resource=" + String.valueOf(this.resource) + ")";
    }

    @Generated
    public WatchableGroovyScriptResource setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }
}

