/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.function;

import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.util.LoggingUtils;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.fi.util.function.CheckedConsumer;
import org.jooq.lambda.fi.util.function.CheckedFunction;
import org.jooq.lambda.fi.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public final class FunctionUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionUtils.class);

    public static <T, R> Function<T, R> doIf(Predicate<Object> condition, Supplier<R> trueFunction, Supplier<R> falseFunction) {
        return t -> {
            try {
                if (condition.test(t)) {
                    return trueFunction.get();
                }
                return falseFunction.get();
            }
            catch (Throwable e) {
                LoggingUtils.warn(LOGGER, e);
                return falseFunction.get();
            }
        };
    }

    public static <T> Consumer<T> doIf(boolean condition, Consumer<T> trueFunction, Consumer<T> falseFunction) {
        return account -> {
            if (condition) {
                trueFunction.accept(account);
            } else {
                falseFunction.accept(account);
            }
        };
    }

    public static <T> Consumer<T> doIf(boolean condition, Consumer<T> trueFunction) {
        return FunctionUtils.doIf(condition, trueFunction, (T __) -> {});
    }

    public static <R> Supplier<R> doIf(boolean condition, Supplier<R> trueFunction, Supplier<R> falseFunction) {
        return () -> {
            try {
                if (condition) {
                    return trueFunction.get();
                }
                return falseFunction.get();
            }
            catch (Throwable e) {
                LoggingUtils.warn(LOGGER, e);
                return falseFunction.get();
            }
        };
    }

    public static <T, R> Function<T, R> doIf(Predicate<T> condition, CheckedFunction<T, R> trueFunction, CheckedFunction<T, R> falseFunction) {
        return t -> {
            try {
                if (condition.test(t)) {
                    return trueFunction.apply(t);
                }
                return falseFunction.apply(t);
            }
            catch (Throwable e) {
                LoggingUtils.warn(LOGGER, e);
                try {
                    return falseFunction.apply(t);
                }
                catch (Throwable ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
            }
        };
    }

    public static <T> void doIfBlank(CharSequence input, CheckedConsumer<T> trueFunction) {
        if (StringUtils.isBlank((CharSequence)input)) {
            FunctionUtils.doAndHandle(trueFunction);
        }
    }

    public static <T> T doIfNotBlank(CharSequence input, CheckedSupplier<T> trueFunction, CheckedSupplier<T> falseFunction) {
        return (T)FunctionUtils.doAndHandle(() -> StringUtils.isNotBlank((CharSequence)input) ? trueFunction.get() : falseFunction.get());
    }

    public static <T extends CharSequence> void doIfNotBlank(T input, CheckedConsumer<T> trueFunction) {
        try {
            if (StringUtils.isNotBlank(input)) {
                trueFunction.accept(input);
            }
        }
        catch (Throwable e) {
            LoggingUtils.warn(LOGGER, e);
        }
    }

    public static <R> R doIfNotNull(Object input, CheckedSupplier<R> trueFunction) {
        return (R)FunctionUtils.doIfNotNull(input, trueFunction, () -> null).get();
    }

    public static <R> Supplier<R> doIfNotNull(Object input, CheckedSupplier<R> trueFunction, Supplier<R> falseFunction) {
        return () -> {
            try {
                if (input != null) {
                    return trueFunction.get();
                }
                return falseFunction.get();
            }
            catch (Throwable e) {
                LoggingUtils.warn(LOGGER, e);
                return falseFunction.get();
            }
        };
    }

    public static <T> void doIfNotNull(T input, CheckedConsumer<T> trueFunction) {
        try {
            if (input != null) {
                trueFunction.accept(input);
            }
        }
        catch (Throwable e) {
            LoggingUtils.warn(LOGGER, e);
        }
    }

    public static <T> void doIfNotNull(T input, CheckedConsumer<T> trueFunction, CheckedConsumer<T> elseFunction) {
        try {
            if (input != null) {
                trueFunction.accept(input);
            } else {
                elseFunction.accept(null);
            }
        }
        catch (Throwable e) {
            LoggingUtils.warn(LOGGER, e);
        }
    }

    public static <T> void doIfNull(T input, CheckedConsumer<T> trueFunction) {
        FunctionUtils.doIfNull(input, trueFunction, t -> {});
    }

    public static <T> void doIfNull(T input, CheckedConsumer<T> trueFunction, CheckedConsumer<T> falseFunction) {
        try {
            if (input == null) {
                trueFunction.accept(null);
            } else {
                falseFunction.accept(input);
            }
        }
        catch (Throwable e) {
            LoggingUtils.warn(LOGGER, e);
        }
    }

    public static <R> Supplier<R> doIfNull(Object input, Supplier<R> trueFunction, Supplier<R> falseFunction) {
        return () -> {
            try {
                if (input == null) {
                    return trueFunction.get();
                }
                return falseFunction.get();
            }
            catch (Throwable e) {
                LoggingUtils.warn(LOGGER, e);
                return falseFunction.get();
            }
        };
    }

    public static <T, R> Function<T, R> doAndHandle(CheckedFunction<T, R> function, CheckedFunction<Throwable, R> errorHandler) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable e) {
                try {
                    LoggingUtils.warn(LOGGER, e);
                    return errorHandler.apply((Object)e);
                }
                catch (Throwable ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
            }
        };
    }

    public static <R> Consumer<R> doAndHandle(CheckedConsumer<R> function, CheckedFunction<Throwable, R> errorHandler) {
        return value -> {
            try {
                function.accept(value);
            }
            catch (Throwable e) {
                try {
                    LoggingUtils.warn(LOGGER, e);
                    errorHandler.apply((Object)e);
                }
                catch (Throwable ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        };
    }

    public static <R> R doAndHandle(CheckedSupplier<R> function) {
        try {
            return (R)function.get();
        }
        catch (InvalidTicketException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LoggingUtils.warn(LOGGER, e);
        }
        return null;
    }

    public static <R> void doAndHandle(CheckedConsumer<R> function) {
        try {
            function.accept(null);
        }
        catch (Throwable e) {
            LoggingUtils.warn(LOGGER, e);
        }
    }

    public static <R> Supplier<R> doAndHandle(CheckedSupplier<R> function, CheckedFunction<Throwable, R> errorHandler) {
        return () -> {
            try {
                return function.get();
            }
            catch (Throwable e) {
                try {
                    LoggingUtils.warn(LOGGER, e);
                    return errorHandler.apply((Object)e);
                }
                catch (Throwable ex) {
                    if (ex instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)ex;
                        throw re;
                    }
                    throw new IllegalArgumentException(ex);
                }
            }
        };
    }

    public static <T> void doWhen(boolean condition, Consumer<T> trueFunction) {
        FunctionUtils.doIf(condition, trueFunction, (T __) -> {}).accept(null);
    }

    public static boolean doWithoutThrows(Consumer<Object> func, Object ... params) {
        try {
            func.accept(params);
            return true;
        }
        catch (Throwable e) {
            LoggingUtils.warn(LOGGER, e);
            return false;
        }
    }

    public static <T> T doUnchecked(CheckedSupplier<T> consumer) {
        return Unchecked.supplier(consumer).get();
    }

    public static void doUnchecked(CheckedConsumer<Object> consumer, Object ... params) {
        Unchecked.consumer(cons -> consumer.accept((Object)params)).accept(null);
    }

    public static <T> T doAndRetry(RetryCallback<T, Exception> callback) throws Exception {
        return FunctionUtils.doAndRetry(List.of(), callback);
    }

    public static <T> T doAndRetry(List<Class<? extends Throwable>> clazzes, RetryCallback<T, Exception> callback) throws Exception {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setBackOffPolicy((BackOffPolicy)new FixedBackOffPolicy());
        HashMap<Class, Boolean> classified = new HashMap<Class, Boolean>();
        classified.put(Error.class, Boolean.TRUE);
        classified.put(Throwable.class, Boolean.TRUE);
        clazzes.forEach(clz -> classified.put((Class)clz, Boolean.TRUE));
        final SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(3, classified, true);
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        retryTemplate.setThrowLastExceptionOnExhausted(true);
        retryTemplate.registerListener(new RetryListener(){

            public boolean open(RetryContext context, RetryCallback __) {
                context.setAttribute("retry.maxAttempts", (Object)retryPolicy.getMaxAttempts());
                return super.open(context, __);
            }
        });
        return (T)retryTemplate.execute(callback);
    }

    public static String throwIfBlank(String value) throws Throwable {
        FunctionUtils.throwIf(StringUtils.isBlank((CharSequence)value), (CheckedSupplier<? extends Throwable>)((CheckedSupplier)() -> new IllegalArgumentException("Value cannot be empty or blank")));
        return value;
    }

    public static <T> T throwIfNull(T value, CheckedSupplier<Throwable> handler) throws Throwable {
        FunctionUtils.throwIf(value == null, handler);
        return value;
    }

    public static void throwIf(boolean condition, CheckedSupplier<? extends Throwable> throwable) throws Throwable {
        if (condition) {
            throw (Throwable)throwable.get();
        }
    }

    public static <T> T doAndReturn(boolean condition, Supplier<T> trueTask, Supplier<T> falseTask) {
        return condition ? trueTask.get() : falseTask.get();
    }

    public static <T> T doAndThrow(CheckedSupplier<T> supplier, Function<Throwable, ? extends Exception> handler) throws Exception {
        try {
            return (T)supplier.get();
        }
        catch (Throwable e) {
            LoggingUtils.error(LOGGER, e);
            throw handler.apply(e);
        }
    }

    public static <T> T doAndThrowUnchecked(CheckedSupplier<T> supplier, Function<Throwable, ? extends RuntimeException> handler) {
        try {
            return (T)supplier.get();
        }
        catch (Throwable e) {
            LoggingUtils.error(LOGGER, e);
            throw handler.apply(e);
        }
    }

    @Generated
    private FunctionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

