/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.io;

import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.File;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.WatcherService;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.fi.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class PathWatcherService
implements WatcherService,
Runnable,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PathWatcherService.class);
    private static final String PROPERTY_DISABLE_WATCHER = PathWatcherService.class.getName();
    private static final WatchEvent.Kind[] KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    @Nullable
    private WatchService watchService;
    private final Consumer<File> onCreate;
    private final Consumer<File> onModify;
    private final Consumer<File> onDelete;
    @Nullable
    private Thread thread;

    public PathWatcherService(File watchablePath, Consumer<File> onModify) {
        this(watchablePath.toPath(), __ -> {}, onModify, __ -> {});
    }

    public PathWatcherService(Path watchablePath, Consumer<File> onCreate, Consumer<File> onModify, Consumer<File> onDelete) {
        LOGGER.info("Watching directory path at [{}]", (Object)watchablePath);
        this.onCreate = onCreate;
        this.onModify = onModify;
        this.onDelete = onDelete;
        if (this.shouldEnableWatchService()) {
            this.initializeWatchService(watchablePath);
        }
    }

    @Override
    public void run() {
        if (this.shouldEnableWatchService()) {
            try {
                WatchKey key = null;
                while ((key = this.watchService.take()) != null) {
                    this.handleEvent(key);
                    boolean valid = key.reset();
                    if (valid) continue;
                    LOGGER.info("Directory key is no longer valid. Quitting watcher service");
                }
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() {
        LOGGER.trace("Closing service registry watcher thread");
        IOUtils.closeQuietly((Closeable)this.watchService);
        if (this.thread != null) {
            this.thread.interrupt();
        }
        LOGGER.trace("Closed service registry watcher thread");
    }

    @Override
    public void start(String name) {
        if (this.shouldEnableWatchService()) {
            LOGGER.trace("Starting watcher thread");
            this.thread = Thread.ofVirtual().name(name).start(this);
        }
    }

    public void destroy() {
        this.close();
    }

    protected void handleEvent(WatchKey key) {
        key.pollEvents().forEach(Unchecked.consumer(event -> {
            String eventName = event.kind().name();
            WatchEvent ev = event;
            Path filename = (Path)ev.context();
            Path parent = (Path)key.watchable();
            Path fullPath = parent.resolve(filename);
            File file = fullPath.toFile();
            LOGGER.trace("Detected event [{}] on file [{}]", (Object)eventName, (Object)file);
            if (eventName.equals(StandardWatchEventKinds.ENTRY_CREATE.name()) && file.exists()) {
                this.onCreate.accept(file);
            } else if (eventName.equals(StandardWatchEventKinds.ENTRY_DELETE.name())) {
                this.onDelete.accept(file);
            } else if (eventName.equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) && file.exists()) {
                this.onModify.accept(file);
            }
        }));
    }

    protected boolean shouldEnableWatchService() {
        String watchServiceEnabled = (String)StringUtils.defaultIfBlank((CharSequence)System.getenv(PROPERTY_DISABLE_WATCHER), (CharSequence)System.getProperty(PROPERTY_DISABLE_WATCHER));
        return StringUtils.isBlank((CharSequence)watchServiceEnabled) || BooleanUtils.toBoolean((String)watchServiceEnabled);
    }

    protected void initializeWatchService(Path watchablePath) {
        this.watchService = (WatchService)FunctionUtils.doUnchecked(() -> watchablePath.getFileSystem().newWatchService());
        LOGGER.trace("Created watcher for events of type [{}]", (Object)Arrays.stream(KINDS).map(WatchEvent.Kind::name).collect(Collectors.joining(",")));
        FunctionUtils.doUnchecked((CheckedConsumer<Object>)((CheckedConsumer)__ -> watchablePath.register(Objects.requireNonNull(this.watchService), KINDS)), new Object[0]);
    }
}

