/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledGroovyScript;
import org.apereo.cas.util.scripting.ScriptResourceCacheManager;
import org.apereo.cas.util.text.MessageSanitizer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class ApplicationContextProvider
implements ApplicationContextAware {
    private static ApplicationContext APPLICATION_CONTEXT;

    public static ApplicationContext getApplicationContext() {
        return APPLICATION_CONTEXT;
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) {
        APPLICATION_CONTEXT = context;
    }

    public static void processBeanInjections(Object bean) {
        ConfigurableApplicationContext ac = ApplicationContextProvider.getConfigurableApplicationContext();
        if (ac != null) {
            AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
            bpp.setBeanFactory((BeanFactory)ac.getAutowireCapableBeanFactory());
            bpp.processInjection(bean);
        }
    }

    public static List<MultifactorAuthenticationPrincipalResolver> getMultifactorAuthenticationPrincipalResolvers() {
        ArrayList<MultifactorAuthenticationPrincipalResolver> resolvers = new ArrayList<MultifactorAuthenticationPrincipalResolver>(APPLICATION_CONTEXT.getBeansOfType(MultifactorAuthenticationPrincipalResolver.class).values());
        AnnotationAwareOrderComparator.sort(resolvers);
        return resolvers;
    }

    public static void holdApplicationContext(ApplicationContext ctx) {
        APPLICATION_CONTEXT = ctx;
    }

    public static <T> T registerBeanIntoApplicationContext(ConfigurableApplicationContext applicationContext, Class<T> beanClazz, String beanId) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        Object provider = beanFactory.createBean(beanClazz);
        beanFactory.initializeBean(provider, beanId);
        beanFactory.autowireBean(provider);
        beanFactory.registerSingleton(beanId, provider);
        return (T)provider;
    }

    public static <T> T registerBeanIntoApplicationContext(ConfigurableApplicationContext applicationContext, T beanInstance, String beanId) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        if (beanFactory.containsBean(beanId)) {
            return (T)applicationContext.getBean(beanId, beanInstance.getClass());
        }
        beanFactory.initializeBean(beanInstance, beanId);
        beanFactory.autowireBean(beanInstance);
        beanFactory.registerSingleton(beanId, beanInstance);
        return beanInstance;
    }

    public static Optional<CasConfigurationProperties> getCasConfigurationProperties() {
        if (APPLICATION_CONTEXT != null) {
            return Optional.of((CasConfigurationProperties)APPLICATION_CONTEXT.getBean(CasConfigurationProperties.class));
        }
        return Optional.empty();
    }

    public static ConfigurableApplicationContext getConfigurableApplicationContext() {
        return (ConfigurableApplicationContext)APPLICATION_CONTEXT;
    }

    public static Optional<ScriptResourceCacheManager<String, ExecutableCompiledGroovyScript>> getScriptResourceCacheManager() {
        return ApplicationContextProvider.getBean("scriptResourceCacheManager", ScriptResourceCacheManager.class);
    }

    public static Optional<MessageSanitizer> getMessageSanitizer() {
        return ApplicationContextProvider.getBean("messageSanitizer", MessageSanitizer.class);
    }

    private static <T> Optional<T> getBean(String name, Class<T> clazz) {
        return ApplicationContextProvider.getBean(APPLICATION_CONTEXT, name, clazz);
    }

    public static <T> Optional<T> getBean(ApplicationContext applicationContext, String name, Class<T> clazz) {
        return (Optional)FunctionUtils.doAndHandle(() -> {
            if (applicationContext != null && applicationContext.containsBean(name)) {
                return Optional.of(applicationContext.getBean(name, clazz));
            }
            return Optional.empty();
        }, e -> Optional.empty()).get();
    }
}

