/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring.beans;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.DisposableBean;

public interface BeanContainer<T>
extends DisposableBean {
    public static <T> BeanContainer<T> of(T ... entries) {
        return new ListBeanContainer(Arrays.stream(entries).collect(Collectors.toList()));
    }

    public static <T> BeanContainer<T> of(List<? extends T> entries) {
        return new ListBeanContainer<T>(new ArrayList<T>(entries));
    }

    public static <T> BeanContainer<T> of(Set<? extends T> entries) {
        return new ListBeanContainer<T>(new ArrayList<T>(entries));
    }

    public static <T> BeanContainer<T> empty() {
        return BeanContainer.of(new Object[0]);
    }

    public List<T> toList();

    public Set<T> toSet();

    public BeanContainer<T> and(T var1);

    public int size();

    public T first();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public BeanContainer<T> forEach(Consumer<T> var1);

    public BeanContainer<T> allOf(Collection<T> var1);

    public static class ListBeanContainer<T>
    implements BeanContainer<T> {
        private final List<T> items;

        @Override
        public List<T> toList() {
            return this.items;
        }

        @Override
        public Set<T> toSet() {
            return new LinkedHashSet<T>(this.items);
        }

        @Override
        @CanIgnoreReturnValue
        public BeanContainer<T> and(T entry) {
            this.items.add(entry);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public BeanContainer<T> allOf(Collection<T> entries) {
            this.items.addAll(entries);
            return this;
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public T first() {
            return this.items.getFirst();
        }

        @Override
        public BeanContainer<T> forEach(Consumer<T> o) {
            this.items.forEach(o);
            return null;
        }

        public void destroy() throws Exception {
            this.items.forEach(Unchecked.consumer(entry -> {
                if (entry instanceof DisposableBean) {
                    DisposableBean disposable = (DisposableBean)entry;
                    disposable.destroy();
                }
                if (entry instanceof Closeable) {
                    Closeable closeable = (Closeable)entry;
                    IOUtils.closeQuietly((Closeable)closeable);
                }
            }));
            this.items.clear();
        }

        @Generated
        public ListBeanContainer(List<T> items) {
            this.items = items;
        }
    }
}

