/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring.beans;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.springframework.core.env.PropertyResolver;

class CompoundCondition
implements BeanCondition {
    private static final Pattern EXPRESSION_PATTERN = RegexUtils.createPattern("\\$\\{.+\\}");
    private final Deque<BeanCondition.Condition> conditionList = new ArrayDeque<BeanCondition.Condition>();

    CompoundCondition(String name) {
        this.and(name);
    }

    CompoundCondition(Collection<BeanCondition.Condition> conditions) {
        this.conditionList.addAll(conditions);
    }

    private static String resolvePropertyValue(PropertyResolver propertyResolver, PropertyCondition condition) {
        try {
            String result = propertyResolver.getProperty(condition.getPropertyName(), condition.getDefaultValue());
            return SpringExpressionLanguageValueResolver.getInstance().resolve(result);
        }
        catch (IllegalArgumentException e) {
            String placeholder = StringUtils.substringBetween((String)e.getMessage(), (String)"\"", (String)"\"");
            Matcher matcher = EXPRESSION_PATTERN.matcher(placeholder);
            if (matcher.find()) {
                String match = matcher.group();
                String result = SpringExpressionLanguageValueResolver.getInstance().resolve(match);
                return placeholder.replaceAll(matcher.pattern().pattern(), result);
            }
            return null;
        }
    }

    @Override
    public BeanCondition toStartWith() {
        return new CompoundCondition(this.conditionList);
    }

    @Override
    public int count() {
        return this.conditionList.size();
    }

    @Override
    @CanIgnoreReturnValue
    public BeanCondition evenIfMissing() {
        BeanCondition.Condition condition = this.conditionList.peek();
        if (condition instanceof PropertyCondition) {
            PropertyCondition condition2 = (PropertyCondition)condition;
            condition2.setMatchIfMissing(true);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public BeanCondition withDefaultValue(String value) {
        BeanCondition.Condition condition = this.conditionList.peek();
        if (condition instanceof PropertyCondition) {
            PropertyCondition condition2 = (PropertyCondition)condition;
            condition2.setDefaultValue(value);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public BeanCondition havingValue(Serializable value) {
        BeanCondition.Condition condition = this.conditionList.peek();
        if (condition instanceof PropertyCondition) {
            PropertyCondition condition2 = (PropertyCondition)condition;
            condition2.setHavingValue(value);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public BeanCondition exists() {
        BeanCondition.Condition condition = this.conditionList.peek();
        if (condition instanceof PropertyCondition) {
            PropertyCondition condition2 = (PropertyCondition)condition;
            condition2.setExists(true);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public BeanCondition isUrl() {
        BeanCondition.Condition condition = this.conditionList.peek();
        if (condition instanceof PropertyCondition) {
            PropertyCondition condition2 = (PropertyCondition)condition;
            condition2.setUrl(true);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public BeanCondition and(String name) {
        this.conditionList.push(new PropertyCondition(name));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public BeanCondition and(Supplier<Boolean> booleanSupplier) {
        this.conditionList.push(new BooleanCondition(booleanSupplier.get()));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public BeanCondition and(BeanCondition.Condition ... condition) {
        Arrays.stream(condition).forEach(this.conditionList::push);
        return this;
    }

    @Override
    public Supplier<Boolean> given(PropertyResolver propertyResolver) {
        return () -> this.conditionList.stream().allMatch(cond -> {
            if (cond instanceof PropertyCondition) {
                PropertyCondition condition = (PropertyCondition)cond;
                if (condition.isMatchIfMissing() && !propertyResolver.containsProperty(condition.getPropertyName())) {
                    return true;
                }
                String result = CompoundCondition.resolvePropertyValue(propertyResolver, condition);
                if (condition.getHavingValue() != null) {
                    return condition.getHavingValue().toString().equalsIgnoreCase(result);
                }
                if (condition.isUrl() && StringUtils.isNotBlank((CharSequence)result)) {
                    return RegexUtils.find("^https*:\\/\\/.+", result);
                }
                if (condition.isExists()) {
                    return ResourceUtils.doesResourceExist(result);
                }
                return StringUtils.isNotBlank((CharSequence)result);
            }
            if (cond instanceof BooleanCondition) {
                BooleanCondition condition = (BooleanCondition)cond;
                return BooleanUtils.toBoolean((Boolean)condition.value());
            }
            return false;
        });
    }

    @Generated
    public CompoundCondition() {
    }

    private static final class PropertyCondition
    implements BeanCondition.Condition {
        private final String propertyName;
        private boolean matchIfMissing;
        private String defaultValue;
        private Serializable havingValue;
        private boolean exists;
        private boolean url;

        @Generated
        public PropertyCondition(String propertyName) {
            this.propertyName = propertyName;
        }

        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @Generated
        public boolean isMatchIfMissing() {
            return this.matchIfMissing;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public Serializable getHavingValue() {
            return this.havingValue;
        }

        @Generated
        public boolean isExists() {
            return this.exists;
        }

        @Generated
        public boolean isUrl() {
            return this.url;
        }

        @Generated
        public void setMatchIfMissing(boolean matchIfMissing) {
            this.matchIfMissing = matchIfMissing;
        }

        @Generated
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Generated
        public void setHavingValue(Serializable havingValue) {
            this.havingValue = havingValue;
        }

        @Generated
        public void setExists(boolean exists) {
            this.exists = exists;
        }

        @Generated
        public void setUrl(boolean url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyCondition)) {
                return false;
            }
            PropertyCondition other = (PropertyCondition)o;
            if (this.matchIfMissing != other.matchIfMissing) {
                return false;
            }
            if (this.exists != other.exists) {
                return false;
            }
            if (this.url != other.url) {
                return false;
            }
            String this$propertyName = this.propertyName;
            String other$propertyName = other.propertyName;
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            String this$defaultValue = this.defaultValue;
            String other$defaultValue = other.defaultValue;
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            Serializable this$havingValue = this.havingValue;
            Serializable other$havingValue = other.havingValue;
            return !(this$havingValue == null ? other$havingValue != null : !this$havingValue.equals(other$havingValue));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.matchIfMissing ? 79 : 97);
            result = result * 59 + (this.exists ? 79 : 97);
            result = result * 59 + (this.url ? 79 : 97);
            String $propertyName = this.propertyName;
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            String $defaultValue = this.defaultValue;
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            Serializable $havingValue = this.havingValue;
            result = result * 59 + ($havingValue == null ? 43 : $havingValue.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CompoundCondition.PropertyCondition(propertyName=" + this.propertyName + ", matchIfMissing=" + this.matchIfMissing + ", defaultValue=" + this.defaultValue + ", havingValue=" + String.valueOf(this.havingValue) + ", exists=" + this.exists + ", url=" + this.url + ")";
        }
    }

    private record BooleanCondition(Boolean value) implements BeanCondition.Condition
    {
    }
}

