/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.nativex;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.lang.module.Configuration;
import java.lang.module.ResolvedModule;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ClassUtils;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.LogMessageSummarizer;
import org.apereo.cas.util.cipher.JsonWebKeySetStringCipherExecutor;
import org.apereo.cas.util.cipher.RsaKeyPairCipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.serialization.ComponentSerializationPlanConfigurer;
import org.apereo.cas.util.thread.Cleanable;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.transform.StaticTypesTransformation;
import org.codehaus.groovy.transform.sc.StaticCompileTransformation;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.SetFactoryBean;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.event.DefaultEventListenerFactory;
import org.springframework.context.event.EventListenerMethodProcessor;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.web.cors.CorsConfigurationSource;

public class CasCoreUtilRuntimeHints
implements CasRuntimeHintsRegistrar {
    private static final int GROOVY_DGM_CLASS_COUNTER = 1500;

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        hints.resources().registerType(CasVersion.class);
        this.registerProxyHints(hints, List.of(ComponentSerializationPlanConfigurer.class, InitializingBean.class, Supplier.class, Runnable.class, Function.class, Consumer.class, Cleanable.class, CorsConfigurationSource.class));
        CasCoreUtilRuntimeHints.registerSerializationHints(hints);
        this.registerDeclaredMethod(hints, Map.Entry.class, "getKey");
        this.registerDeclaredMethod(hints, Map.Entry.class, "getValue");
        this.registerDeclaredMethod(hints, Map.class, "isEmpty");
        hints.reflection().registerType(Map.Entry.class, new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_METHODS}).registerType(TypeReference.of((String)"java.util.LinkedHashMap$Entry"), new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS}).registerType(TypeReference.of((String)"java.util.TreeMap$Entry"), new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS}).registerType(LinkedHashMap.class, new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS}).registerType(TypeReference.of((String)"java.util.HashMap$Node"), new MemberCategory[0]).registerType(TypeReference.of((String)"java.util.HashMap$TreeNode"), new MemberCategory[0]).registerType(HashMap.class, new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS}).registerType(AbstractCollection.class, new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS}).registerType(AbstractMap.class, new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS}).registerType(Callable.class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS}).registerType(Map.class, new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS}).registerType(TypeReference.of((String)"java.time.Ser"), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS}).registerType(TypeReference.of((String)"java.time.Clock$SystemClock"), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_CONSTRUCTORS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS});
        CasCoreUtilRuntimeHints.registerReflectionHintForMethods(hints, List.of(BigDecimal.class, BigInteger.class, Math.class, URL.class, URI.class, SetFactoryBean.class, ListFactoryBean.class, CasVersion.class, Module.class, Class.class, Arrays.class, Collections.class, Collection.class, List.class, Iterator.class, Iterable.class, Queue.class, Set.class, Comparator.class, Comparable.class, ResultSet.class, Calendar.class, Date.class, SortedMap.class, SortedSet.class, TimeZone.class, BiPredicate.class, BiFunction.class, Predicate.class, Function.class, Consumer.class, Supplier.class, ModuleLayer.class, Configuration.class, ResolvedModule.class, ServiceLoader.class));
        CasCoreUtilRuntimeHints.registerReflectionHintForPublicOps(hints, List.of(RsaKeyPairCipherExecutor.class, JsonWebKeySetStringCipherExecutor.class, System.class));
        CasCoreUtilRuntimeHints.registerReflectionHintForConstructors(hints, List.of(TriStateBoolean.Deserializer.class, PersistenceAnnotationBeanPostProcessor.class, ConfigurationClassPostProcessor.class, EventListenerMethodProcessor.class, DefaultEventListenerFactory.class, AutowiredAnnotationBeanPostProcessor.class, CommonAnnotationBeanPostProcessor.class));
        CasCoreUtilRuntimeHints.registerReflectionHintForPublicOps(hints, this.findSubclassesInPackage(ObjectIdGenerator.class, new String[]{"com.fasterxml.jackson"}));
        CasCoreUtilRuntimeHints.registerReflectionHintForPublicOps(hints, this.findSubclassesInPackage(LogMessageSummarizer.class, new String[]{"org.apereo.cas"}));
        this.registerCaffeineHints(hints);
        CasCoreUtilRuntimeHints.registerGroovyDGMClasses(hints, classLoader);
        FunctionUtils.doAndHandle(__ -> {
            Class clazz = ClassUtils.getClass((String)"nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler", (boolean)false);
            this.registerReflectionHintForAll(hints, this.findSubclassesInPackage(clazz, new String[]{"nonapi.io.github.classgraph.classloaderhandler"}));
        });
        this.registerReflectionHintForAll(hints, List.of(StaticCompileTransformation.class, StaticTypesTransformation.class, GroovyClassLoader.class, BytecodeInterface8.class, Script.class, LoggerFactory.class, Stack.class));
    }

    private static void registerGroovyDGMClasses(RuntimeHints hints, ClassLoader classLoader) {
        IntStream.range(1, 1500).forEach(idx -> hints.reflection().registerTypeIfPresent(classLoader, "org.codehaus.groovy.runtime.dgm$" + idx, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.PUBLIC_FIELDS}));
    }

    private void registerCaffeineHints(RuntimeHints hints) {
        FunctionUtils.doAndHandle(__ -> {
            Class clazz = ClassUtils.getClass((String)"com.github.benmanes.caffeine.cache.Node", (boolean)false);
            CasCoreUtilRuntimeHints.registerReflectionHintForConstructors(hints, this.findSubclassesInPackage(clazz, new String[]{"com.github.benmanes.caffeine.cache"}));
            clazz = ClassUtils.getClass((String)"com.github.benmanes.caffeine.cache.LocalCache", (boolean)false);
            CasCoreUtilRuntimeHints.registerReflectionHintForConstructors(hints, this.findSubclassesInPackage(clazz, new String[]{"com.github.benmanes.caffeine.cache"}));
        });
    }

    private static void registerSerializationHints(RuntimeHints hints) {
        hints.serialization().registerType(Boolean.class).registerType(Double.class).registerType(Integer.class).registerType(Long.class).registerType(String.class).registerType(ZonedDateTime.class).registerType(LocalDateTime.class).registerType(LocalDate.class).registerType(ZoneId.class).registerType(ZoneOffset.class).registerType(ArrayList.class).registerType(Vector.class).registerType(CopyOnWriteArrayList.class).registerType(LinkedList.class).registerType(HashMap.class).registerType(LinkedHashMap.class).registerType(ConcurrentHashMap.class).registerType(TreeMap.class).registerType(ConcurrentSkipListSet.class).registerType(HashSet.class).registerType(LinkedHashSet.class).registerType(CopyOnWriteArraySet.class).registerType(TreeSet.class).registerType(TypeReference.of((String)"java.time.Clock$SystemClock")).registerType(TypeReference.of((String)"java.time.Clock$OffsetClock")).registerType(TypeReference.of((String)"java.time.Clock$FixedClock")).registerType(TypeReference.of((String)"java.lang.String$CaseInsensitiveComparator"));
    }

    private static void registerReflectionHintForConstructors(RuntimeHints hints, Collection clazzes) {
        clazzes.forEach(clazz -> hints.reflection().registerType((Class)clazz, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS}));
    }

    private static void registerReflectionHintForMethods(RuntimeHints hints, Collection clazzes) {
        clazzes.forEach(clazz -> hints.reflection().registerType((Class)clazz, new MemberCategory[]{MemberCategory.PUBLIC_FIELDS, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS}));
    }

    private static void registerReflectionHintForPublicOps(RuntimeHints hints, Collection clazzes) {
        clazzes.forEach(clazz -> hints.reflection().registerType((Class)clazz, new MemberCategory[]{MemberCategory.PUBLIC_FIELDS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
    }

    private void registerReflectionHintForAll(RuntimeHints hints, Collection clazzes) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.PUBLIC_FIELDS};
        clazzes.forEach(entry -> {
            if (entry instanceof String) {
                String clazzName = (String)entry;
                hints.reflection().registerTypeIfPresent(this.getClass().getClassLoader(), clazzName, memberCategories);
            }
            if (entry instanceof Class) {
                Class clazz = (Class)entry;
                hints.reflection().registerType(clazz, memberCategories);
            }
        });
    }
}

