/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.nativex;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import groovy.lang.Script;
import java.lang.module.Configuration;
import java.lang.module.ResolvedModule;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.ResultSet;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ClassUtils;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.LogMessageSummarizer;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.serialization.ComponentSerializationPlanConfigurer;
import org.apereo.cas.util.thread.Cleanable;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.transform.StaticTypesTransformation;
import org.codehaus.groovy.transform.sc.StaticCompileTransformation;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.SetFactoryBean;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.event.DefaultEventListenerFactory;
import org.springframework.context.event.EventListenerMethodProcessor;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.web.cors.CorsConfigurationSource;

public class CasCoreUtilRuntimeHints
implements CasRuntimeHintsRegistrar {
    private static final int GROOVY_DGM_CLASS_COUNTER = 1500;

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        hints.resources().registerType(CasVersion.class);
        this.registerProxyHints(hints, List.of(ComponentSerializationPlanConfigurer.class, InitializingBean.class, Supplier.class, Runnable.class, Function.class, Consumer.class, Cleanable.class, CorsConfigurationSource.class));
        this.registerSerializationHints(hints);
        this.registerReflectionHintForDeclaredMethod(hints, Map.Entry.class, "getKey");
        this.registerReflectionHintForDeclaredMethod(hints, Map.Entry.class, "getValue");
        this.registerReflectionHintForDeclaredMethod(hints, Map.class, "isEmpty");
        this.registerReflectionHintsForMethodsAndFields(hints, List.of(BigDecimal.class, BigInteger.class, Math.class, URL.class, URI.class, SetFactoryBean.class, ListFactoryBean.class, CasVersion.class, Module.class, Class.class, Arrays.class, Collections.class, Collection.class, List.class, Iterator.class, Iterable.class, Queue.class, Set.class, Comparator.class, Comparable.class, ResultSet.class, Calendar.class, Date.class, SortedMap.class, SortedSet.class, TimeZone.class, BiPredicate.class, BiFunction.class, Predicate.class, Function.class, Consumer.class, Supplier.class, ModuleLayer.class, Configuration.class, ResolvedModule.class, ServiceLoader.class, Callable.class, Map.class));
        this.registerReflectionHintsForPublicElements(hints, List.of(System.class));
        this.registerReflectionHintsForDeclaredElements(hints, List.of(HashMap.class, LinkedHashMap.class, TypeReference.of((String)"java.time.Ser")));
        this.registerReflectionHintsForIntrospectedPublicElements(hints, List.of(TypeReference.of((String)"java.util.LinkedHashMap$Entry"), TypeReference.of((String)"java.util.TreeMap$Entry")));
        this.registerReflectionHints(hints, List.of(ClassUtils.class, LoggerFactory.class, StaticCompileTransformation.class, StaticTypesTransformation.class, Script.class, BytecodeInterface8.class));
        this.registerReflectionHintsForConstructors(hints, List.of(TriStateBoolean.Deserializer.class, PersistenceAnnotationBeanPostProcessor.class, ConfigurationClassPostProcessor.class, EventListenerMethodProcessor.class, DefaultEventListenerFactory.class, AutowiredAnnotationBeanPostProcessor.class, CommonAnnotationBeanPostProcessor.class));
        this.registerReflectionHintsForTypes(hints, List.of(TypeReference.of((String)"java.util.HashMap$Node"), TypeReference.of((String)"java.util.HashMap$TreeNode")));
        this.registerReflectionHintsForTypes(hints, this.findSubclassesInPackage(Clock.class, new String[]{Clock.class.getPackageName()}));
        this.registerReflectionHintsForPublicElements(hints, this.findSubclassesInPackage(ObjectIdGenerator.class, new String[]{"com.fasterxml.jackson"}));
        this.registerReflectionHintsForPublicElements(hints, this.findSubclassesInPackage(LogMessageSummarizer.class, new String[]{"org.apereo.cas"}));
        this.registerReflectionHintsForPublicElements(hints, this.findSubclassesInPackage(CipherExecutor.class, new String[]{"org.apereo.cas"}));
        this.registerCaffeineHints(hints);
        CasCoreUtilRuntimeHints.registerGroovyDGMClasses(hints, classLoader);
        FunctionUtils.doAndHandle(__ -> {
            Class clazz = ClassUtils.getClass((String)"nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler", (boolean)false);
            this.registerReflectionHints(hints, this.findSubclassesInPackage(clazz, new String[]{"nonapi.io.github.classgraph.classloaderhandler"}));
        });
    }

    private static void registerGroovyDGMClasses(RuntimeHints hints, ClassLoader classLoader) {
        IntStream.range(1, 1500).forEach(idx -> hints.reflection().registerTypeIfPresent(classLoader, "org.codehaus.groovy.runtime.dgm$" + idx, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.PUBLIC_FIELDS}));
    }

    private void registerCaffeineHints(RuntimeHints hints) {
        FunctionUtils.doAndHandle(__ -> {
            Class clazz = ClassUtils.getClass((String)"com.github.benmanes.caffeine.cache.Node", (boolean)false);
            this.registerReflectionHintsForConstructors(hints, this.findSubclassesInPackage(clazz, new String[]{"com.github.benmanes.caffeine.cache"}));
            clazz = ClassUtils.getClass((String)"com.github.benmanes.caffeine.cache.LocalCache", (boolean)false);
            this.registerReflectionHintsForConstructors(hints, this.findSubclassesInPackage(clazz, new String[]{"com.github.benmanes.caffeine.cache"}));
        });
    }

    private void registerSerializationHints(RuntimeHints hints) {
        this.registerSerializationHints(hints, new Object[]{Boolean.class, Double.class, Integer.class, Long.class, String.class, ZonedDateTime.class, LocalDateTime.class, LocalDate.class, LocalTime.class, ZoneId.class, ZoneOffset.class, Instant.class, ArrayList.class, Vector.class, CopyOnWriteArrayList.class, LinkedList.class, HashMap.class, LinkedHashMap.class, ConcurrentHashMap.class, TreeMap.class, ConcurrentSkipListSet.class, HashSet.class, LinkedHashSet.class, CopyOnWriteArraySet.class, TreeSet.class, TypeReference.of((String)"java.lang.String$CaseInsensitiveComparator")});
        this.registerSerializationHints(hints, this.findSubclassesInPackage(Clock.class, new String[]{Clock.class.getPackageName()}));
    }
}

