/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
public abstract class AbstractCasProtocolValidationSpecification
implements CasProtocolValidationSpecification {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCasProtocolValidationSpecification.class);
    private final ServicesManager servicesManager;
    private boolean renew;

    public boolean isSatisfiedBy(Assertion assertion, HttpServletRequest request) {
        LOGGER.trace("Is validation specification set to enforce [{}] protocol behavior? [{}]. Is assertion issued from a new login? [{}]", new Object[]{"renew", BooleanUtils.toStringYesNo((boolean)this.renew), BooleanUtils.toStringYesNo((boolean)assertion.isFromNewLogin())});
        boolean satisfied = this.isSatisfiedByInternal(assertion);
        if (!satisfied) {
            LOGGER.warn("[{}] is not internally satisfied by the produced assertion", (Object)this.getClass().getSimpleName());
            return false;
        }
        boolean bl = satisfied = !this.renew || assertion.isFromNewLogin();
        if (!satisfied) {
            LOGGER.warn("[{}] is to enforce the [{}] CAS protocol behavior, yet the assertion is not issued from a new login", (Object)this.getClass().getSimpleName(), (Object)"renew");
            return false;
        }
        LOGGER.trace("Validation specification is satisfied by the produced assertion");
        return true;
    }

    public void reset() {
        this.setRenew(false);
    }

    protected abstract boolean isSatisfiedByInternal(Assertion var1);

    @Generated
    public void setRenew(boolean renew) {
        this.renew = renew;
    }

    @Generated
    protected AbstractCasProtocolValidationSpecification(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    @Generated
    protected AbstractCasProtocolValidationSpecification(ServicesManager servicesManager, boolean renew) {
        this.servicesManager = servicesManager;
        this.renew = renew;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public boolean isRenew() {
        return this.renew;
    }
}

