/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.core.web.LocaleProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.support.RequestContextUtils;

public class CasLocaleChangeInterceptor
extends LocaleChangeInterceptor {
    protected final LocaleProperties localeProperties;
    protected final ArgumentExtractor argumentExtractor;
    protected final ServicesManager servicesManager;
    private List<String> supportedFlows = new ArrayList<String>();

    protected static void configureLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
        if (localeResolver != null) {
            localeResolver.setLocale(request, response, locale);
            request.setAttribute(Locale.class.getName(), (Object)locale);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        boolean match;
        String newLocale;
        Locale locale;
        RegisteredService registeredService;
        String requestUrl = request.getRequestURL().toString();
        if (this.localeProperties.isForceDefaultLocale()) {
            Locale locale2 = new Locale(this.localeProperties.getDefaultValue());
            CasLocaleChangeInterceptor.configureLocale(request, response, locale2);
            return true;
        }
        WebApplicationService service = this.argumentExtractor.extractService(request);
        if (service != null && (registeredService = this.servicesManager.findServiceBy((Service)service)) != null && StringUtils.isNotBlank((CharSequence)registeredService.getLocale())) {
            locale = new Locale(SpringExpressionLanguageValueResolver.getInstance().resolve(registeredService.getLocale()));
            CasLocaleChangeInterceptor.configureLocale(request, response, locale);
        }
        if ((newLocale = request.getParameter(this.getParamName())) != null) {
            locale = new Locale(newLocale);
            CasLocaleChangeInterceptor.configureLocale(request, response, locale);
        }
        if (request.getLocale() != null && CasLocaleChangeInterceptor.isLocaleConfigured(request) && (match = this.supportedFlows.stream().anyMatch(flowId -> requestUrl.contains("/" + flowId)))) {
            Locale locale3 = RequestContextUtils.getLocale((HttpServletRequest)request);
            CasLocaleChangeInterceptor.configureLocale(request, response, locale3);
        }
        return true;
    }

    private static boolean isLocaleConfigured(HttpServletRequest request) {
        return request.getAttribute(Locale.class.getName()) == null;
    }

    @Generated
    public CasLocaleChangeInterceptor(LocaleProperties localeProperties, ArgumentExtractor argumentExtractor, ServicesManager servicesManager) {
        this.localeProperties = localeProperties;
        this.argumentExtractor = argumentExtractor;
        this.servicesManager = servicesManager;
    }

    @Generated
    public void setSupportedFlows(List<String> supportedFlows) {
        this.supportedFlows = supportedFlows;
    }
}

