/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.HttpClientProperties;
import org.apereo.cas.configuration.model.core.web.MessageBundleProperties;
import org.apereo.cas.web.CasYamlHttpMessageConverter;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.apereo.cas.web.view.CasReloadableMessageBundle;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.http.converter.HttpMessageConverter;

@Configuration(value="CasCoreWebConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreWebConfiguration {

    @Configuration(value="CasCoreWebEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebEndpointsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casProtocolEndpointConfigurer"})
        public ProtocolEndpointWebSecurityConfigurer<Void> casProtocolEndpointConfigurer() {
            return new ProtocolEndpointWebSecurityConfigurer<Void>(){

                public List<String> getIgnoredEndpoints() {
                    return List.of(StringUtils.prependIfMissing((String)"/login", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/logout", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/validate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/serviceValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/p3/serviceValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/proxyValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/p3/proxyValidate", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/proxy", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
                }
            };
        }
    }

    @Configuration(value="CasCoreWebRequestsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebRequestsConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"argumentExtractor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ArgumentExtractor argumentExtractor(List<ServiceFactoryConfigurer> configurers) {
            ArrayList serviceFactoryList = new ArrayList();
            configurers.forEach(c -> serviceFactoryList.addAll(c.buildServiceFactories()));
            AnnotationAwareOrderComparator.sortIfNecessary(configurers);
            return new DefaultArgumentExtractor(serviceFactoryList);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"urlValidator"})
        public FactoryBean<UrlValidator> urlValidator(CasConfigurationProperties casProperties) {
            HttpClientProperties httpClient = casProperties.getHttpClient();
            boolean allowLocalLogoutUrls = httpClient.isAllowLocalUrls();
            String authorityValidationRegEx = httpClient.getAuthorityValidationRegex();
            boolean authorityValidationRegExCaseSensitive = httpClient.isAuthorityValidationRegExCaseSensitive();
            return new SimpleUrlValidatorFactoryBean(allowLocalLogoutUrls, authorityValidationRegEx, authorityValidationRegExCaseSensitive);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"yamlHttpMessageConverter"})
        public HttpMessageConverter yamlHttpMessageConverter() {
            return new CasYamlHttpMessageConverter();
        }
    }

    @Configuration(value="CasCoreWebMessageSourceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebMessageSourceConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PropertiesFactoryBean casCommonMessages(CasConfigurationProperties casProperties) {
            PropertiesFactoryBean properties = new PropertiesFactoryBean();
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            List commonNames = casProperties.getMessageBundle().getCommonNames();
            List resourceList = commonNames.stream().map(arg_0 -> ((DefaultResourceLoader)resourceLoader).getResource(arg_0)).collect(Collectors.toList());
            resourceList.add(resourceLoader.getResource("classpath:/cas_common_messages.properties"));
            properties.setLocations((Resource[])resourceList.toArray(Resource[]::new));
            properties.setSingleton(true);
            properties.setIgnoreResourceNotFound(true);
            return properties;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public HierarchicalMessageSource messageSource(CasConfigurationProperties casProperties, @Qualifier(value="casCommonMessages") Properties casCommonMessages) {
            CasReloadableMessageBundle bean = new CasReloadableMessageBundle();
            MessageBundleProperties mb = casProperties.getMessageBundle();
            bean.setDefaultEncoding(mb.getEncoding());
            bean.setCacheSeconds(mb.getCacheSeconds());
            bean.setFallbackToSystemLocale(mb.isFallbackSystemLocale());
            bean.setUseCodeAsDefaultMessage(mb.isUseCodeMessage());
            bean.setBasenames(mb.getBaseNames().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
            bean.setCommonMessages(casCommonMessages);
            return bean;
        }
    }
}

