/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseSingleSignOnParticipationStrategy
implements SingleSignOnParticipationStrategy {
    protected final ServicesManager servicesManager;
    protected final TicketRegistrySupport ticketRegistrySupport;
    protected final AuthenticationServiceSelectionPlan serviceSelectionStrategy;

    protected static Authentication getAuthenticationFrom(SingleSignOnParticipationRequest ssoRequest) {
        return ssoRequest.getRequestContext().map(WebUtils::getAuthentication).orElseGet(() -> (Authentication)ssoRequest.getAttributeValue(Authentication.class.getName(), Authentication.class));
    }

    protected static Optional<String> getTicketGrantingTicketId(SingleSignOnParticipationRequest ssoRequest) {
        return Optional.ofNullable(ssoRequest.getRequestContext().map(WebUtils::getTicketGrantingTicketId).orElseGet(() -> (String)ssoRequest.getAttributeValue(TicketGrantingTicket.class.getName(), String.class)));
    }

    protected RegisteredService getRegisteredService(SingleSignOnParticipationRequest ssoRequest) {
        return ssoRequest.getRequestContext().map(requestContext -> WebUtils.resolveRegisteredService((RequestContext)requestContext, (ServicesManager)this.servicesManager, (AuthenticationServiceSelectionPlan)this.serviceSelectionStrategy)).orElseGet(() -> (RegisteredService)ssoRequest.getAttributeValue(RegisteredService.class.getName(), RegisteredService.class));
    }

    protected Optional<TicketState> getTicketState(SingleSignOnParticipationRequest ssoRequest) {
        String tgtId = BaseSingleSignOnParticipationStrategy.getTicketGrantingTicketId(ssoRequest).orElse("");
        return Optional.ofNullable(this.ticketRegistrySupport.getTicketState(tgtId));
    }

    @Generated
    public BaseSingleSignOnParticipationStrategy(ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan serviceSelectionStrategy) {
        this.servicesManager = servicesManager;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
    }
}

