/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.RegExUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public class CasDefaultFlowUrlHandler
extends DefaultFlowUrlHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasDefaultFlowUrlHandler.class);
    public static final String DEFAULT_FLOW_EXECUTION_KEY_PARAMETER = "execution";
    private static final String DELIMITER = "&";
    private String flowExecutionKeyParameter = "execution";

    private static Stream<String> encodeMultiParameter(String key, String[] values, String encoding) {
        return Stream.of(values).map(value -> CasDefaultFlowUrlHandler.encodeSingleParameter(key, value, encoding));
    }

    private static String encodeSingleParameter(String key, String value, String encoding) {
        return EncodingUtils.urlEncode((String)key, (String)encoding) + "=" + EncodingUtils.urlEncode((String)value, (String)encoding);
    }

    public String getFlowExecutionKey(HttpServletRequest request) {
        return request.getParameter(this.flowExecutionKeyParameter);
    }

    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, HttpServletRequest request) {
        String encoding = this.getEncodingScheme(request);
        String executionKey = CasDefaultFlowUrlHandler.encodeSingleParameter(this.flowExecutionKeyParameter, flowExecutionKey, encoding);
        String url = request.getParameterMap().entrySet().stream().flatMap(entry -> CasDefaultFlowUrlHandler.encodeMultiParameter((String)entry.getKey(), (String[])entry.getValue(), encoding)).collect(Collectors.joining(DELIMITER, request.getRequestURI() + "?", DELIMITER + executionKey));
        LOGGER.trace("Final flow execution url is [{}]", (Object)url);
        return url;
    }

    public String createFlowDefinitionUrl(String flowId, AttributeMap input, HttpServletRequest request) {
        return HttpRequestUtils.getFullRequestUrl((HttpServletRequest)request);
    }

    public String getFlowId(HttpServletRequest request) {
        String flowId = super.getFlowId(request);
        if (flowId.contains("#")) {
            flowId = RegExUtils.removePattern((String)flowId, (String)"#.*");
        }
        return flowId.trim();
    }

    @Generated
    public void setFlowExecutionKeyParameter(String flowExecutionKeyParameter) {
        this.flowExecutionKeyParameter = flowExecutionKeyParameter;
    }
}

