/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.BasicSubflowExpression;
import org.apereo.cas.web.flow.configurer.DynamicFlowModelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.service.RuntimeBindingConversionExecutor;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.spel.SpringELExpressionParser;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.impl.DefaultMapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.action.ExternalRedirectAction;
import org.springframework.webflow.action.RenderAction;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.action.ViewFactoryActionAdapter;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.DecisionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowVariable;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.VariableValueFactory;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.WildcardTransitionCriteria;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.model.FlowModelFlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.model.builder.DefaultFlowModelHolder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;
import org.springframework.webflow.engine.support.ActionExecutingViewFactory;
import org.springframework.webflow.engine.support.ActionTransitionCriteria;
import org.springframework.webflow.engine.support.BeanFactoryVariableValueFactory;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.engine.support.GenericSubflowAttributeMapper;
import org.springframework.webflow.engine.support.TransitionCriteriaChain;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.expression.spel.ActionPropertyAccessor;
import org.springframework.webflow.expression.spel.BeanFactoryPropertyAccessor;
import org.springframework.webflow.expression.spel.FlowVariablePropertyAccessor;
import org.springframework.webflow.expression.spel.MapAdaptablePropertyAccessor;
import org.springframework.webflow.expression.spel.MessageSourcePropertyAccessor;
import org.springframework.webflow.expression.spel.ScopeSearchingPropertyAccessor;

public abstract class AbstractCasWebflowConfigurer
implements CasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCasWebflowConfigurer.class);
    private static final Action[] EMPTY_ACTIONS_ARRAY = new Action[0];
    protected final FlowBuilderServices flowBuilderServices;
    protected final FlowDefinitionRegistry mainFlowDefinitionRegistry;
    protected final ConfigurableApplicationContext applicationContext;
    protected final CasConfigurationProperties casProperties;
    protected FlowDefinitionRegistry logoutFlowDefinitionRegistry;
    private int order;
    private String name = this.getClass().getSimpleName();

    private static TransitionCriteria getTransitionCriteriaForExpression(Expression criteriaOutcomeExpression) {
        if (criteriaOutcomeExpression.toString().equals("*")) {
            return WildcardTransitionCriteria.INSTANCE;
        }
        return new DefaultTransitionCriteria(criteriaOutcomeExpression);
    }

    public void initialize() {
        FunctionUtils.doAndHandle(o -> {
            LOGGER.trace("Initializing CAS webflow configuration...");
            if (this.casProperties.getWebflow().getAutoConfiguration().isEnabled()) {
                this.doInitialize();
            } else {
                LOGGER.info("Webflow auto-configuration is disabled for [{}]", (Object)this.getClass().getName());
            }
        }, throwable -> null).accept(this);
    }

    public Flow getLoginFlow() {
        return this.getFlow("login");
    }

    public Flow getLogoutFlow() {
        if (this.logoutFlowDefinitionRegistry == null) {
            LOGGER.warn("Logout flow registry is not configured correctly.");
            return null;
        }
        return (Flow)this.logoutFlowDefinitionRegistry.getFlowDefinition("logout");
    }

    public TransitionableState getStartState(Flow flow) {
        return (TransitionableState)flow.getStartState();
    }

    public Transition createTransition(String criteriaOutcome, String targetState) {
        return this.createTransition((Expression)new LiteralExpression(criteriaOutcome), targetState, new Action[0]);
    }

    public Transition createTransition(String criteriaOutcome, String targetState, Action ... actions) {
        return this.createTransition((Expression)new LiteralExpression(criteriaOutcome), targetState, actions);
    }

    public Transition createTransition(String criteriaOutcome, TransitionableState targetState) {
        return this.createTransition((Expression)new LiteralExpression(criteriaOutcome), targetState.getId(), new Action[0]);
    }

    public Transition createTransition(Expression criteriaOutcomeExpression, String targetState, Action ... actions) {
        TransitionCriteria criteria = AbstractCasWebflowConfigurer.getTransitionCriteriaForExpression(criteriaOutcomeExpression);
        Transition transition = new Transition(criteria, (TargetStateResolver)(StringUtils.isNotBlank((CharSequence)targetState) ? new DefaultTargetStateResolver(targetState) : null));
        if (actions != null && actions.length > 0) {
            ActionTransitionCriteria[] transitionActionCriteria = (ActionTransitionCriteria[])Arrays.stream(actions).map(ActionTransitionCriteria::new).toArray(ActionTransitionCriteria[]::new);
            transition.setExecutionCriteria((TransitionCriteria)new TransitionCriteriaChain((TransitionCriteria[])transitionActionCriteria));
        }
        return transition;
    }

    public Transition createTransition(String targetState) {
        DefaultTargetStateResolver resolver = new DefaultTargetStateResolver(targetState);
        return new Transition((TargetStateResolver)resolver);
    }

    public RenderAction createRenderAction(String ... fragmentExpression) {
        FluentParserContext ctx = new FluentParserContext();
        ExpressionParser expressionParser = this.flowBuilderServices.getExpressionParser();
        Expression[] expressions = (Expression[])Arrays.stream(fragmentExpression).map(fg -> expressionParser.parseExpression(fg, (ParserContext)ctx)).toArray(Expression[]::new);
        RenderAction newAction = new RenderAction(expressions);
        LOGGER.trace("Created render action for expressions [{}]", (Object)Arrays.toString(fragmentExpression));
        return newAction;
    }

    public SetAction createSetAction(String name, String value) {
        return new SetAction(this.createExpression(name), this.createExpression(value));
    }

    public EvaluateAction createEvaluateAction(String expression) {
        if (this.flowBuilderServices == null) {
            LOGGER.warn("Flow builder services is not configured correctly.");
            return null;
        }
        FluentParserContext ctx = new FluentParserContext();
        Expression action = this.flowBuilderServices.getExpressionParser().parseExpression(expression, (ParserContext)ctx);
        EvaluateAction newAction = new EvaluateAction(action, null);
        LOGGER.trace("Created evaluate action for expression [{}]", (Object)action.getExpressionString());
        return newAction;
    }

    public ActionState createActionState(Flow flow, String name) {
        return this.createActionState(flow, name, EMPTY_ACTIONS_ARRAY);
    }

    public ActionState createActionState(Flow flow, String name, String ... action) {
        List<EvaluateAction> actionList = Arrays.stream(action).map(this::createEvaluateAction).toList();
        return this.createActionState(flow, name, actionList.toArray(EMPTY_ACTIONS_ARRAY));
    }

    public ActionState createActionState(Flow flow, String name, Action ... actions) {
        if (this.containsFlowState(flow, name)) {
            LOGGER.trace("Flow [{}] already contains a definition for state id [{}]", (Object)flow.getId(), (Object)name);
            return this.getTransitionableState(flow, name, ActionState.class);
        }
        ActionState actionState = new ActionState(flow, name);
        LOGGER.trace("Created action state [{}]", (Object)actionState.getId());
        actionState.getActionList().addAll(actions);
        LOGGER.trace("Added action to the action state [{}] list of actions: [{}]", (Object)actionState.getId(), (Object)actionState.getActionList());
        return actionState;
    }

    public ActionState createActionState(Flow flow, String name, Action action) {
        return this.createActionState(flow, name, new Action[]{action});
    }

    public DecisionState createDecisionState(Flow flow, String id, String testExpression, String thenStateId, String elseStateId) {
        if (this.containsFlowState(flow, id)) {
            LOGGER.trace("Flow [{}] already contains a definition for state id [{}]", (Object)flow.getId(), (Object)id);
            return this.getTransitionableState(flow, id, DecisionState.class);
        }
        DecisionState decisionState = new DecisionState(flow, id);
        Expression expression = this.createExpression(testExpression, Boolean.class);
        Transition thenTransition = this.createTransition(expression, thenStateId, new Action[0]);
        decisionState.getTransitionSet().add(thenTransition);
        Transition elseTransition = this.createTransition("*", elseStateId);
        decisionState.getTransitionSet().add(elseTransition);
        return decisionState;
    }

    public void setStartState(Flow flow, String state) {
        flow.setStartState(state);
        TransitionableState startState = this.getStartState(flow);
        LOGGER.trace("Start state is now set to [{}]", (Object)startState.getId());
    }

    public void setStartState(Flow flow, TransitionableState state) {
        this.setStartState(flow, state.getId());
    }

    public EndState createEndState(Flow flow, String id) {
        return this.createEndState(flow, id, (ViewFactory)null);
    }

    public EndState createEndState(Flow flow, String id, String viewId, boolean redirect) {
        if (!redirect) {
            return this.createEndState(flow, id, viewId);
        }
        return this.createEndState(flow, id, this.createExternalRedirectViewFactory(viewId));
    }

    public EndState createEndState(Flow flow, String id, String viewId) {
        return this.createEndState(flow, id, (Expression)new LiteralExpression(viewId));
    }

    public EndState createEndState(Flow flow, String id, Expression expression) {
        ViewFactory viewFactory = this.flowBuilderServices.getViewFactoryCreator().createViewFactory(expression, this.flowBuilderServices.getExpressionParser(), this.flowBuilderServices.getConversionService(), null, this.flowBuilderServices.getValidator(), this.flowBuilderServices.getValidationHintResolver());
        return this.createEndState(flow, id, viewFactory);
    }

    public EndState createEndState(Flow flow, String id, ViewFactory viewFactory) {
        if (this.containsFlowState(flow, id)) {
            LOGGER.trace("Flow [{}] already contains a definition for state id [{}]", (Object)flow.getId(), (Object)id);
            return (EndState)flow.getStateInstance(id);
        }
        EndState endState = new EndState(flow, id);
        if (viewFactory != null) {
            ViewFactoryActionAdapter finalResponseAction = new ViewFactoryActionAdapter(viewFactory);
            endState.setFinalResponseAction((Action)finalResponseAction);
            LOGGER.trace("Created end state state [{}] on flow id [{}], backed by view factory [{}]", new Object[]{id, flow.getId(), viewFactory});
        } else {
            LOGGER.trace("Created end state state [{}] on flow id [{}]", (Object)id, (Object)flow.getId());
        }
        return endState;
    }

    public ViewState createViewState(Flow flow, String id, Expression expression, BinderConfiguration binder) {
        if (this.containsFlowState(flow, id)) {
            LOGGER.trace("Flow [{}] already contains a definition for state id [{}]", (Object)flow.getId(), (Object)id);
            return this.getTransitionableState(flow, id, ViewState.class);
        }
        ViewFactory viewFactory = this.flowBuilderServices.getViewFactoryCreator().createViewFactory(expression, this.flowBuilderServices.getExpressionParser(), this.flowBuilderServices.getConversionService(), binder, this.flowBuilderServices.getValidator(), this.flowBuilderServices.getValidationHintResolver());
        return this.createViewState(flow, id, viewFactory);
    }

    public ViewState createViewState(Flow flow, String id, ViewFactory viewFactory) {
        try {
            if (this.containsFlowState(flow, id)) {
                LOGGER.trace("Flow [{}] already contains a definition for state id [{}]", (Object)flow.getId(), (Object)id);
                return this.getTransitionableState(flow, id, ViewState.class);
            }
            ViewState viewState = new ViewState(flow, id, viewFactory);
            LOGGER.trace("Added view state [{}]", (Object)viewState.getId());
            return viewState;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    public ViewState createViewState(Flow flow, String id, String viewId) {
        return this.createViewState(flow, id, (Expression)new LiteralExpression(viewId), null);
    }

    public ViewState createViewState(Flow flow, String id, String viewId, BinderConfiguration binder) {
        return this.createViewState(flow, id, (Expression)new LiteralExpression(viewId), binder);
    }

    public SubflowState createSubflowState(Flow flow, String stateId, String subflow, Action entryAction) {
        if (this.containsFlowState(flow, stateId)) {
            LOGGER.trace("Flow [{}] already contains a definition for state id [{}]", (Object)flow.getId(), (Object)stateId);
            return this.getTransitionableState(flow, stateId, SubflowState.class);
        }
        SubflowState state = new SubflowState(flow, stateId, (Expression)new BasicSubflowExpression(subflow, this.mainFlowDefinitionRegistry));
        if (entryAction != null) {
            state.getEntryActionList().add(entryAction);
        }
        return state;
    }

    public SubflowState createSubflowState(Flow flow, String stateId, String subflow) {
        return this.createSubflowState(flow, stateId, subflow, null);
    }

    public Flow buildFlow(String id) {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, this.flowBuilderServices);
        builder.setParent(this.mainFlowDefinitionRegistry);
        builder.addFlowBuilder((FlowBuilder)new FlowModelFlowBuilder((FlowModelHolder)new DefaultFlowModelHolder((FlowModelBuilder)new DynamicFlowModelBuilder())), id);
        FlowDefinitionRegistry registry = builder.build();
        return (Flow)registry.getFlowDefinition(id);
    }

    public void createStateDefaultTransition(TransitionableState state, String targetState) {
        if (state == null) {
            LOGGER.trace("Cannot add default transition of [{}] to the given state is null and cannot be found in the flow.", (Object)targetState);
            return;
        }
        Transition transition = this.createTransition(targetState);
        state.getTransitionSet().add(transition);
    }

    public void createStateDefaultTransition(TransitionableState state, StateDefinition targetState) {
        this.createStateDefaultTransition(state, targetState.getId());
    }

    public Transition createTransitionForState(TransitionableState state, String criteriaOutcome, String targetState, Map<String, Object> attributes) {
        return this.createTransitionForState(state, criteriaOutcome, targetState, false, attributes);
    }

    public Transition createTransitionForState(TransitionableState state, String criteriaOutcome) {
        return this.createTransitionForState(state, criteriaOutcome, "");
    }

    public Transition createTransitionForState(TransitionableState state, String criteriaOutcome, String targetState) {
        return this.createTransitionForState(state, criteriaOutcome, targetState, Map.of());
    }

    public Transition createTransitionForState(TransitionableState state, String criteriaOutcome, String targetState, Map<String, Object> attributes, Action ... actions) {
        return this.createTransitionForState(state, criteriaOutcome, targetState, false, attributes, actions);
    }

    public Transition createTransitionForState(TransitionableState state, String criteriaOutcome, String targetState, Action ... actions) {
        return this.createTransitionForState(state, criteriaOutcome, targetState, false, Map.of(), actions);
    }

    public Transition createTransitionForState(Flow flow, String stateId, String criteriaOutcome, String targetState) {
        return this.createTransitionForState(this.getTransitionableState(flow, stateId), criteriaOutcome, targetState, false, Map.of());
    }

    public Transition createTransitionForState(TransitionableState state, String criteriaOutcome, String targetState, boolean removeExisting, Map<String, Object> attributes, Action ... actions) {
        try {
            Transition transition;
            if (removeExisting) {
                transition = null;
                do {
                    if ((transition = (Transition)state.getTransition(criteriaOutcome)) == null) continue;
                    state.getTransitionSet().remove(transition);
                } while (transition != null);
            }
            transition = this.createTransition(criteriaOutcome, targetState, actions);
            attributes.forEach((key, value) -> transition.getAttributes().put(key, value));
            state.getTransitionSet().add(transition);
            LOGGER.trace("Added transition [{}] to the state [{}]", (Object)transition.getId(), (Object)state.getId());
            return transition;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    public Transition createTransitionForState(TransitionableState state, String criteriaOutcome, String targetState, boolean removeExisting, Map<String, Object> attributes) {
        return this.createTransitionForState(state, criteriaOutcome, targetState, removeExisting, attributes, new Action[0]);
    }

    public Transition createTransitionForState(TransitionableState state, String criteriaOutcome, String targetState, boolean removeExisting) {
        return this.createTransitionForState(state, criteriaOutcome, targetState, removeExisting, Map.of(), new Action[0]);
    }

    public Transition insertTransitionForState(TransitionableState state, String criteriaOutcome, String targetState) {
        Transition transition = this.createTransition(criteriaOutcome, targetState, new Action[0]);
        Field field = ReflectionUtils.findField(state.getTransitionSet().getClass(), (String)"transitions");
        ReflectionUtils.makeAccessible((Field)field);
        List transitions = (List)ReflectionUtils.getField((Field)field, (Object)state.getTransitionSet());
        Objects.requireNonNull(transitions).add(0, transition);
        LOGGER.trace("Added transition [{}] to the state [{}]", (Object)transition.getId(), (Object)state.getId());
        return transition;
    }

    public Expression createExpression(String expression, Class expectedType) {
        FluentParserContext parserContext = new FluentParserContext().expectResult(expectedType);
        return this.getSpringExpressionParser().parseExpression(expression, (ParserContext)parserContext);
    }

    public Expression createExpression(String expression) {
        return this.createExpression(expression, null);
    }

    public boolean containsFlowState(Flow flow, String stateId) {
        if (flow == null) {
            LOGGER.error("Flow is not configured correctly and cannot be null.");
            return false;
        }
        return flow.containsState(stateId);
    }

    public boolean containsSubflowState(Flow flow, String stateId) {
        return this.containsFlowState(flow, stateId) && this.getState(flow, stateId, SubflowState.class) != null;
    }

    public boolean containsTransition(TransitionableState state, String transition) {
        if (state == null) {
            LOGGER.error("State is not configured correctly and cannot be null.");
            return false;
        }
        return state.getTransition(transition) != null;
    }

    public FlowVariable createFlowVariable(Flow flow, String id, Class type) {
        Optional<FlowVariable> opt = Arrays.stream(flow.getVariables()).filter(v -> v.getName().equalsIgnoreCase(id)).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        FlowVariable flowVar = new FlowVariable(id, (VariableValueFactory)new BeanFactoryVariableValueFactory(type, this.applicationContext.getAutowireCapableBeanFactory()));
        flow.addVariable(flowVar);
        return flowVar;
    }

    public BinderConfiguration createStateBinderConfiguration(Map<String, Map<String, String>> properties) {
        BinderConfiguration binder = new BinderConfiguration();
        properties.forEach((key, value) -> {
            String converter = (String)value.get("converter");
            boolean required = BooleanUtils.toBoolean((String)value.getOrDefault("required", Boolean.TRUE.toString()));
            BinderConfiguration.Binding binding = new BinderConfiguration.Binding(key, converter, required);
            binder.addBinding(binding);
        });
        return binder;
    }

    public BinderConfiguration createStateBinderConfiguration(List<String> properties) {
        BinderConfiguration binder = new BinderConfiguration();
        properties.forEach(p -> binder.addBinding(new BinderConfiguration.Binding(p, null, true)));
        return binder;
    }

    public void createStateModelBinding(TransitionableState state, String modelName, Class modelType) {
        LOGGER.trace("Creating model binding [{}] with type [{}] for [{}]", new Object[]{modelName, modelType, state.getId()});
        state.getAttributes().put("model", (Object)this.createExpression(modelName, modelType));
    }

    public BinderConfiguration getViewStateBinderConfiguration(ViewState state) {
        Field field = ReflectionUtils.findField((Class)state.getViewFactory().getClass(), (String)"binderConfiguration");
        ReflectionUtils.makeAccessible((Field)field);
        return (BinderConfiguration)ReflectionUtils.getField((Field)field, (Object)state.getViewFactory());
    }

    public List<TransitionCriteria> getTransitionExecutionCriteriaChainForTransition(Transition def) {
        TransitionCriteria transitionCriteria = def.getExecutionCriteria();
        if (transitionCriteria instanceof TransitionCriteriaChain) {
            TransitionCriteriaChain chain = (TransitionCriteriaChain)transitionCriteria;
            Field field = ReflectionUtils.findField(chain.getClass(), (String)"criteriaChain");
            Assert.notNull((Object)field, (String)"criteriaChain cannot be null");
            ReflectionUtils.makeAccessible((Field)field);
            return (List)ReflectionUtils.getField((Field)field, (Object)chain);
        }
        if (def.getExecutionCriteria() != null) {
            return CollectionUtils.wrapList((Object[])new TransitionCriteria[]{def.getExecutionCriteria()});
        }
        return new ArrayList<TransitionCriteria>(0);
    }

    public <T> T getState(Flow flow, String stateId, Class<T> clazz) {
        if (this.containsFlowState(flow, stateId)) {
            StateDefinition state = flow.getState(stateId);
            return clazz.cast(state);
        }
        return null;
    }

    public TransitionableState getState(Flow flow, String stateId) {
        return this.getState(flow, stateId, TransitionableState.class);
    }

    public Flow getFlow(String id) {
        return this.getFlow(this.mainFlowDefinitionRegistry, id);
    }

    public Flow getFlow(FlowDefinitionRegistry registry, String id) {
        if (registry == null) {
            LOGGER.warn("Flow registry is not configured and/or initialized correctly.");
            return null;
        }
        boolean found = Arrays.asList(registry.getFlowDefinitionIds()).contains(id);
        if (found) {
            return (Flow)registry.getFlowDefinition(id);
        }
        LOGGER.warn("Could not find flow definition [{}]. Available flow definition ids are [{}]", (Object)id, (Object)registry.getFlowDefinitionIds());
        return null;
    }

    public SpringELExpressionParser getSpringExpressionParser() {
        SpelParserConfiguration configuration = new SpelParserConfiguration();
        SpelExpressionParser spelExpressionParser = new SpelExpressionParser(configuration);
        SpringELExpressionParser parser = new SpringELExpressionParser(spelExpressionParser, this.flowBuilderServices.getConversionService());
        parser.addPropertyAccessor((PropertyAccessor)new ActionPropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new BeanFactoryPropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new FlowVariablePropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new MapAdaptablePropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new MessageSourcePropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new ScopeSearchingPropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new MapAdaptablePropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new ReflectivePropertyAccessor());
        return parser;
    }

    public Mapper createFlowInputMapper(List<DefaultMapping> mappings, Flow flow) {
        DefaultMapper flowInputMapper = flow.getInputMapper() == null ? new DefaultMapper() : (DefaultMapper)flow.getInputMapper();
        mappings.forEach(arg_0 -> ((DefaultMapper)flowInputMapper).addMapping(arg_0));
        flow.setInputMapper((Mapper)flowInputMapper);
        return flowInputMapper;
    }

    public Mapper createFlowInputMapper(List<DefaultMapping> mappings) {
        DefaultMapper flowInputMapper = new DefaultMapper();
        mappings.forEach(arg_0 -> ((DefaultMapper)flowInputMapper).addMapping(arg_0));
        return flowInputMapper;
    }

    public DefaultMapping createMappingToSubflowState(String name, String value, boolean required, Class type) {
        ExpressionParser parser = this.flowBuilderServices.getExpressionParser();
        Expression source = parser.parseExpression(value, (ParserContext)new FluentParserContext());
        Expression target = parser.parseExpression(name, (ParserContext)new FluentParserContext());
        DefaultMapping mapping = new DefaultMapping(source, target);
        mapping.setRequired(required);
        RuntimeBindingConversionExecutor typeConverter = new RuntimeBindingConversionExecutor(type, this.flowBuilderServices.getConversionService());
        mapping.setTypeConverter((ConversionExecutor)typeConverter);
        return mapping;
    }

    public SubflowAttributeMapper createSubflowAttributeMapper(Mapper inputMapper, Mapper outputMapper) {
        return new GenericSubflowAttributeMapper(inputMapper, outputMapper);
    }

    public void cloneActionState(ActionState source, ActionState target) {
        source.getActionList().forEach(a -> target.getActionList().add(a));
        source.getExitActionList().forEach(a -> target.getExitActionList().add(a));
        source.getAttributes().asMap().forEach((k, v) -> target.getAttributes().put(k, v));
        source.getTransitionSet().forEach(t -> target.getTransitionSet().addAll(new Transition[]{t}));
        Field field = ReflectionUtils.findField(target.getExceptionHandlerSet().getClass(), (String)"exceptionHandlers");
        Assert.notNull((Object)field, (String)"exceptionHandlers cannot be null");
        ReflectionUtils.makeAccessible((Field)field);
        List list = (List)ReflectionUtils.getField((Field)field, (Object)target.getExceptionHandlerSet());
        Objects.requireNonNull(list).forEach(h -> source.getExceptionHandlerSet().add(h));
        target.setDescription(source.getDescription());
        target.setCaption(source.getCaption());
    }

    public Expression getExpressionStringFromAction(EvaluateAction act) {
        Field field = ReflectionUtils.findField(act.getClass(), (String)"expression");
        Assert.notNull((Object)field, (String)"expression cannot be null");
        ReflectionUtils.makeAccessible((Field)field);
        return (Expression)ReflectionUtils.getField((Field)field, (Object)act);
    }

    public Action createEvaluateActionForExistingActionState(Flow flow, String actionStateId, String evaluateActionId) {
        ActionState action = this.getState(flow, actionStateId, ActionState.class);
        Action[] actions = action.getActionList().toArray();
        Arrays.stream(actions).forEach(arg_0 -> ((ActionList)action.getActionList()).remove(arg_0));
        EvaluateAction evaluateAction = this.createEvaluateAction(evaluateActionId);
        action.getActionList().add((Action)evaluateAction);
        action.getActionList().addAll(actions);
        return evaluateAction;
    }

    public void createClonedActionState(Flow flow, String actionStateId, String actionStateIdToClone) {
        ActionState generateServiceTicket = this.getState(flow, actionStateIdToClone, ActionState.class);
        ActionState consentTicketAction = this.createActionState(flow, actionStateId);
        this.cloneActionState(generateServiceTicket, consentTicketAction);
    }

    public <T extends TransitionableState> T getTransitionableState(Flow flow, String stateId, Class<T> clazz) {
        if (this.containsFlowState(flow, stateId)) {
            TransitionableState state = flow.getTransitionableState(stateId);
            return (T)((TransitionableState)clazz.cast(state));
        }
        return null;
    }

    public TransitionableState getTransitionableState(Flow flow, String stateId) {
        if (this.containsFlowState(flow, stateId)) {
            return flow.getTransitionableState(stateId);
        }
        return null;
    }

    public void createTransitionsForState(Flow flow, String stateId, Map<String, String> criteriaAndTargets) {
        if (this.containsFlowState(flow, stateId)) {
            TransitionableState state = this.getState(flow, stateId);
            criteriaAndTargets.forEach((k, v) -> this.createTransitionForState(state, (String)k, (String)v));
        }
    }

    public void prependActionsToActionStateExecutionList(Flow flow, String actionStateId, String ... actions) {
        EvaluateAction[] evalActions = (EvaluateAction[])Arrays.stream(actions).map(this::createEvaluateAction).toArray(EvaluateAction[]::new);
        this.addActionsToActionStateExecutionListAt(flow, actionStateId, 0, evalActions);
    }

    public void prependActionsToActionStateExecutionList(Flow flow, ActionState actionStateId, EvaluateAction ... actions) {
        this.addActionsToActionStateExecutionListAt(flow, actionStateId.getId(), 0, actions);
    }

    public void addActionsToActionStateExecutionListAt(Flow flow, String actionStateId, int position, EvaluateAction ... actions) {
        ActionState actionState = this.getState(flow, actionStateId, ActionState.class);
        ActionList actionList = actionState.getActionList();
        ArrayList<Action> currentActions = new ArrayList<Action>(actionList.size() + actions.length);
        actionList.forEach(currentActions::add);
        int index = position < 0 || position == Integer.MAX_VALUE ? currentActions.size() : position;
        currentActions.forEach(arg_0 -> ((ActionList)actionList).remove(arg_0));
        Arrays.stream(actions).forEach(a -> currentActions.add(index, (Action)a));
        actionList.addAll((Action[])currentActions.toArray(Action[]::new));
    }

    public ViewFactory createExternalRedirectViewFactory(String expressionId) {
        Expression expression = this.createExpression(expressionId, String.class);
        return new ActionExecutingViewFactory((Action)new ExternalRedirectAction(expression));
    }

    protected void doInitialize() {
    }

    @Generated
    public void setLogoutFlowDefinitionRegistry(FlowDefinitionRegistry logoutFlowDefinitionRegistry) {
        this.logoutFlowDefinitionRegistry = logoutFlowDefinitionRegistry;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public FlowBuilderServices getFlowBuilderServices() {
        return this.flowBuilderServices;
    }

    @Generated
    public FlowDefinitionRegistry getMainFlowDefinitionRegistry() {
        return this.mainFlowDefinitionRegistry;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public FlowDefinitionRegistry getLogoutFlowDefinitionRegistry() {
        return this.logoutFlowDefinitionRegistry;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    protected AbstractCasWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry mainFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        this.flowBuilderServices = flowBuilderServices;
        this.mainFlowDefinitionRegistry = mainFlowDefinitionRegistry;
        this.applicationContext = applicationContext;
        this.casProperties = casProperties;
    }

    @Generated
    public String toString() {
        return "AbstractCasWebflowConfigurer(name=" + this.name + ")";
    }
}

