/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.flow.CasDefaultFlowUrlHandler;
import org.apereo.cas.web.flow.CasFlowHandlerAdapter;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.LogoutConversionService;
import org.apereo.cas.web.flow.configurer.DefaultLoginWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.DefaultLogoutWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.DynamicFlowModelBuilder;
import org.apereo.cas.web.flow.configurer.GroovyWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.plan.DefaultCasWebflowExecutionPlan;
import org.apereo.cas.web.flow.executor.WebflowExecutorFactory;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CasLocaleChangeInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;
import org.springframework.web.servlet.theme.ThemeChangeInterceptor;
import org.springframework.webflow.config.FlowBuilderServicesBuilder;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.engine.builder.model.FlowModelFlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.model.builder.DefaultFlowModelHolder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser;
import org.springframework.webflow.mvc.builder.MvcViewFactoryCreator;
import org.springframework.webflow.mvc.servlet.FlowHandlerMapping;

@Configuration(value="CasWebflowContextConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasWebflowContextConfiguration {
    private static final int LOGOUT_FLOW_HANDLER_ORDER = 3;
    private static final FlowExecutionListener[] FLOW_EXECUTION_LISTENERS = new FlowExecutionListener[0];

    @Bean
    public InitializingBean casWebflowExecutionPlanInitializer(@Qualifier(value="loginFlowHandlerMapping") ObjectProvider<CasFlowHandlerMapping> loginFlowHandlerMapping, @Qualifier(value="casWebflowExecutionPlan") CasWebflowExecutionPlan webflowExecutionPlan) {
        return () -> {
            webflowExecutionPlan.execute();
            loginFlowHandlerMapping.ifAvailable(mapping -> {
                mapping.setInterceptors(webflowExecutionPlan.getWebflowInterceptors().toArray());
                mapping.initApplicationContext();
            });
        };
    }

    public static class CasFlowHandlerMapping
    extends FlowHandlerMapping {
        public void initApplicationContext() throws BeansException {
            super.initApplicationContext();
        }
    }

    @Configuration(value="CasWebflowExecutionConfiguration", proxyBeanMethods=false)
    public static class CasWebflowExecutionConfiguration {
        @Bean
        public CasWebflowExecutionPlan casWebflowExecutionPlan(List<CasWebflowExecutionPlanConfigurer> configurers) {
            DefaultCasWebflowExecutionPlan plan = new DefaultCasWebflowExecutionPlan();
            configurers.forEach(c -> c.configureWebflowExecutionPlan((CasWebflowExecutionPlan)plan));
            return plan;
        }
    }

    @Configuration(value="CasWebflowDefinitionsConfiguration", proxyBeanMethods=false)
    public static class CasWebflowDefinitionsConfiguration {
        @Bean
        public FlowDefinitionRegistry logoutFlowRegistry(ConfigurableApplicationContext applicationContext, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder) {
            FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
            builder.addFlowBuilder(flowBuilder, "logout");
            return builder.build();
        }

        @Bean
        public FlowDefinitionRegistry loginFlowRegistry(ConfigurableApplicationContext applicationContext, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder) {
            FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
            builder.addFlowBuilder(flowBuilder, "login");
            return builder.build();
        }
    }

    @Configuration(value="CasWebflowContextBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasWebflowContextBuilderConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FlowBuilderServices flowBuilderServices(@Qualifier(value="viewFactoryCreator") ViewFactoryCreator viewFactoryCreator, @Qualifier(value="expressionParser") ExpressionParser expressionParser) {
            FlowBuilderServicesBuilder builder = new FlowBuilderServicesBuilder();
            builder.setViewFactoryCreator(viewFactoryCreator);
            builder.setExpressionParser(expressionParser);
            return builder.build();
        }

        @Bean
        public ExpressionParser expressionParser(@Qualifier(value="logoutConversionService") ConversionService logoutConversionService) {
            return new WebFlowSpringELExpressionParser(new SpelExpressionParser(), logoutConversionService);
        }

        @Bean
        public ConversionService logoutConversionService() {
            return new LogoutConversionService();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public ViewFactoryCreator viewFactoryCreator(ObjectProvider<List<ViewResolver>> resolversProvider, @Qualifier(value="registeredServiceViewResolver") ObjectProvider<ViewResolver> registeredServiceViewResolver) {
            ViewResolver viewResolver = (ViewResolver)registeredServiceViewResolver.getIfAvailable();
            MvcViewFactoryCreator resolver = new MvcViewFactoryCreator();
            if (viewResolver != null) {
                resolver.setViewResolvers(CollectionUtils.wrap((Object)viewResolver));
            } else if (resolversProvider.getIfAvailable() != null) {
                ArrayList resolvers = new ArrayList((Collection)resolversProvider.getObject());
                AnnotationAwareOrderComparator.sort(resolvers);
                resolver.setViewResolvers(resolvers);
            }
            return resolver;
        }

        @Bean
        public FlowBuilder flowBuilder() {
            return new FlowModelFlowBuilder((FlowModelHolder)new DefaultFlowModelHolder((FlowModelBuilder)new DynamicFlowModelBuilder()));
        }
    }

    @Configuration(value="CasWebflowContextExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasWebflowContextExecutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"defaultWebflowConfigurer"})
        @Bean
        @Order(value=-2147483648)
        public CasWebflowConfigurer defaultWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            DefaultLoginWebflowConfigurer c = new DefaultLoginWebflowConfigurer(flowBuilderServices, loginFlowRegistry, applicationContext, casProperties);
            c.setLogoutFlowDefinitionRegistry(logoutFlowRegistry);
            c.setOrder(Integer.MIN_VALUE);
            return c;
        }

        @ConditionalOnMissingBean(name={"defaultLogoutWebflowConfigurer"})
        @Bean
        @Order(value=-2147483648)
        public CasWebflowConfigurer defaultLogoutWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            DefaultLogoutWebflowConfigurer c = new DefaultLogoutWebflowConfigurer(flowBuilderServices, loginFlowRegistry, applicationContext, casProperties);
            c.setLogoutFlowDefinitionRegistry(logoutFlowRegistry);
            c.setOrder(Integer.MIN_VALUE);
            return c;
        }

        @ConditionalOnMissingBean(name={"groovyWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer groovyWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            GroovyWebflowConfigurer c = new GroovyWebflowConfigurer(flowBuilderServices, loginFlowRegistry, applicationContext, casProperties);
            c.setLogoutFlowDefinitionRegistry(logoutFlowRegistry);
            return c;
        }

        @ConditionalOnMissingBean(name={"casDefaultWebflowExecutionPlanConfigurer"})
        @Bean
        public CasWebflowExecutionPlanConfigurer casDefaultWebflowExecutionPlanConfigurer(@Qualifier(value="defaultWebflowConfigurer") CasWebflowConfigurer defaultWebflowConfigurer, @Qualifier(value="defaultLogoutWebflowConfigurer") CasWebflowConfigurer defaultLogoutWebflowConfigurer, @Qualifier(value="groovyWebflowConfigurer") CasWebflowConfigurer groovyWebflowConfigurer, @Qualifier(value="localeChangeInterceptor") LocaleChangeInterceptor localeChangeInterceptor, @Qualifier(value="resourceUrlProviderExposingInterceptor") ResourceUrlProviderExposingInterceptor resourceUrlProviderExposingInterceptor, @Qualifier(value="themeChangeInterceptor") ObjectProvider<ThemeChangeInterceptor> themeChangeInterceptor, @Qualifier(value="authenticationThrottlingExecutionPlan") ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan) {
            return plan -> {
                plan.registerWebflowConfigurer(defaultWebflowConfigurer);
                plan.registerWebflowConfigurer(defaultLogoutWebflowConfigurer);
                plan.registerWebflowConfigurer(groovyWebflowConfigurer);
                plan.registerWebflowInterceptor((HandlerInterceptor)localeChangeInterceptor);
                plan.registerWebflowInterceptor((HandlerInterceptor)resourceUrlProviderExposingInterceptor);
                themeChangeInterceptor.ifAvailable(arg_0 -> ((CasWebflowExecutionPlan)plan).registerWebflowInterceptor(arg_0));
                authenticationThrottlingExecutionPlan.ifAvailable(throttlingPlan -> throttlingPlan.getAuthenticationThrottleInterceptors().forEach(arg_0 -> ((CasWebflowExecutionPlan)plan).registerWebflowInterceptor(arg_0)));
            };
        }
    }

    @Configuration(value="CasWebflowContextInterceptorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasWebflowContextInterceptorConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"localeChangeInterceptor"})
        public LocaleChangeInterceptor localeChangeInterceptor(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
            CasLocaleChangeInterceptor interceptor = new CasLocaleChangeInterceptor(casProperties.getLocale(), argumentExtractor, servicesManager);
            interceptor.setParamName(casProperties.getLocale().getParamName());
            interceptor.setSupportedFlows(List.of("logout", "login"));
            return interceptor;
        }

        @Bean
        @ConditionalOnMissingBean(name={"resourceUrlProviderExposingInterceptor"})
        public ResourceUrlProviderExposingInterceptor resourceUrlProviderExposingInterceptor(@Qualifier(value="mvcResourceUrlProvider") ResourceUrlProvider resourceUrlProvider) {
            return new ResourceUrlProviderExposingInterceptor(resourceUrlProvider);
        }
    }

    @Configuration(value="CasWebflowContextFlowExecutorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasWebflowContextFlowExecutorConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FlowExecutor logoutFlowExecutor(CasConfigurationProperties casProperties, @Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowRegistry, @Qualifier(value="webflowCipherExecutor") CipherExecutor webflowCipherExecutor) {
            WebflowExecutorFactory factory = new WebflowExecutorFactory(casProperties.getWebflow(), logoutFlowRegistry, webflowCipherExecutor, FLOW_EXECUTION_LISTENERS);
            return factory.build();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FlowExecutor loginFlowExecutor(CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="webflowCipherExecutor") CipherExecutor webflowCipherExecutor) {
            WebflowExecutorFactory factory = new WebflowExecutorFactory(casProperties.getWebflow(), loginFlowRegistry, webflowCipherExecutor, FLOW_EXECUTION_LISTENERS);
            return factory.build();
        }
    }

    @Configuration(value="CasWebflowContextFlowHandlerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasWebflowContextFlowHandlerConfiguration {
        @Bean
        public FlowUrlHandler loginFlowUrlHandler() {
            return new CasDefaultFlowUrlHandler();
        }

        @Bean
        public FlowUrlHandler logoutFlowUrlHandler() {
            return new CasDefaultFlowUrlHandler();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public HandlerAdapter logoutHandlerAdapter(@Qualifier(value="logoutFlowUrlHandler") FlowUrlHandler logoutFlowUrlHandler, @Qualifier(value="logoutFlowExecutor") FlowExecutor logoutFlowExecutor) {
            CasFlowHandlerAdapter handler = new CasFlowHandlerAdapter("logout");
            handler.setFlowExecutor(logoutFlowExecutor);
            handler.setFlowUrlHandler(logoutFlowUrlHandler);
            return handler;
        }

        @Bean
        public CasFlowHandlerMapping loginFlowHandlerMapping(@Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry) {
            CasFlowHandlerMapping handler = new CasFlowHandlerMapping();
            handler.setOrder(2);
            handler.setFlowRegistry(loginFlowRegistry);
            return handler;
        }

        @Bean
        public HandlerAdapter loginHandlerAdapter(@Qualifier(value="loginFlowExecutor") FlowExecutor loginFlowExecutor, @Qualifier(value="loginFlowUrlHandler") FlowUrlHandler loginFlowUrlHandler) {
            CasFlowHandlerAdapter handler = new CasFlowHandlerAdapter("login");
            handler.setFlowExecutor(loginFlowExecutor);
            handler.setFlowUrlHandler(loginFlowUrlHandler);
            return handler;
        }

        @Bean
        public HandlerMapping logoutFlowHandlerMapping(@Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowRegistry, @Qualifier(value="localeChangeInterceptor") LocaleChangeInterceptor localeChangeInterceptor, @Qualifier(value="resourceUrlProviderExposingInterceptor") ResourceUrlProviderExposingInterceptor resourceUrlProviderExposingInterceptor) {
            FlowHandlerMapping handler = new FlowHandlerMapping();
            handler.setOrder(3);
            handler.setFlowRegistry(logoutFlowRegistry);
            handler.setInterceptors(new Object[]{localeChangeInterceptor, resourceUrlProviderExposingInterceptor});
            return handler;
        }
    }
}

