/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.CentralAuthenticationServiceContext;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ContextualAuthenticationPolicy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceContext;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

public abstract class AbstractCentralAuthenticationService
implements CentralAuthenticationService,
Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCentralAuthenticationService.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final long serialVersionUID = -7572316677901391166L;
    protected final CentralAuthenticationServiceContext configurationContext;

    @Transactional(transactionManager="ticketTransactionManager", noRollbackFor={InvalidTicketException.class})
    public Ticket getTicket(@NonNull String ticketId) throws InvalidTicketException {
        if (ticketId == null) {
            throw new NullPointerException("ticketId is marked non-null but is null");
        }
        Ticket ticket = this.configurationContext.getTicketRegistry().getTicket(ticketId);
        this.verifyTicketState(ticket, ticketId, null);
        return ticket;
    }

    @Transactional(transactionManager="ticketTransactionManager", noRollbackFor={InvalidTicketException.class})
    public <T extends Ticket> T getTicket(@NonNull String ticketId, Class<T> clazz) throws InvalidTicketException {
        if (ticketId == null) {
            throw new NullPointerException("ticketId is marked non-null but is null");
        }
        Ticket ticket = this.configurationContext.getTicketRegistry().getTicket(ticketId, clazz);
        this.verifyTicketState(ticket, ticketId, clazz);
        return (T)ticket;
    }

    @Transactional(transactionManager="ticketTransactionManager")
    public Collection<Ticket> getTickets(Predicate<Ticket> predicate) {
        try (Stream<Ticket> ticketsStream = this.configurationContext.getTicketRegistry().stream().filter(predicate);){
            Collection collection = ticketsStream.collect(Collectors.toSet());
            return collection;
        }
    }

    @Transactional(transactionManager="ticketTransactionManager")
    public Stream<? extends Ticket> getTickets(Predicate<Ticket> predicate, long from, long count) {
        return this.configurationContext.getTicketRegistry().stream().filter(predicate).skip(from).limit(count);
    }

    @Audit(action="TICKET_DESTROYED", actionResolverName="DESTROY_TICKET_RESOLVER", resourceResolverName="DESTROY_TICKET_RESOURCE_RESOLVER")
    @Transactional(transactionManager="ticketTransactionManager")
    public int deleteTicket(String ticketId) throws Exception {
        return StringUtils.isNotBlank((CharSequence)ticketId) ? this.configurationContext.getTicketRegistry().deleteTicket(ticketId) : 0;
    }

    public Ticket updateTicket(Ticket ticket) throws Exception {
        this.configurationContext.getTicketRegistry().updateTicket(ticket);
        return ticket;
    }

    public Ticket addTicket(Ticket ticket) throws Exception {
        this.configurationContext.getTicketRegistry().addTicket(ticket);
        return ticket;
    }

    protected void doPublishEvent(ApplicationEvent e) {
        if (this.configurationContext.getApplicationContext() != null) {
            LOGGER.trace("Publishing [{}]", (Object)e);
            this.configurationContext.getApplicationContext().publishEvent(e);
        }
    }

    protected Authentication getAuthenticationSatisfiedByPolicy(Authentication authentication, ServiceContext context) throws AbstractTicketException {
        ContextualAuthenticationPolicy policy = this.configurationContext.getAuthenticationPolicyFactory().createPolicy((Object)context);
        try {
            if (policy.isSatisfiedBy(authentication)) {
                return authentication;
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new UnsatisfiedAuthenticationPolicyException(policy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void evaluateProxiedServiceIfNeeded(Service service, TicketGrantingTicket ticketGrantingTicket, RegisteredService registeredService) {
        Service proxiedBy = ticketGrantingTicket.getProxiedBy();
        if (proxiedBy != null) {
            LOGGER.debug("Ticket-granting ticket is proxied by [{}]. Locating proxy service in registry...", (Object)proxiedBy.getId());
            RegisteredService proxyingService = this.configurationContext.getServicesManager().findServiceBy(proxiedBy);
            if (proxyingService != null) {
                LOGGER.debug("Located proxying service [{}] in the service registry", (Object)proxyingService);
                if (proxyingService.getProxyPolicy().isAllowedToProxy()) return;
                LOGGER.warn("Proxying service [{}] is not authorized to fulfill the proxy attempt made by [{}]", (Object)proxyingService.getId(), (Object)service.getId());
                throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
            }
            LOGGER.warn("Proxy attempt by service [{}] (registered service [{}]) is not allowed.", (Object)service.getId(), (Object)registeredService.getId());
            throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
        }
        LOGGER.trace("Ticket-granting ticket is not proxied by another service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyTicketState(Ticket ticket, String id, Class clazz) {
        Object object = this.$lock;
        synchronized (object) {
            if (ticket == null) {
                LOGGER.debug("Ticket [{}] by type [{}] cannot be found in the ticket registry.", (Object)id, (Object)(clazz != null ? clazz.getSimpleName() : "unspecified"));
                throw new InvalidTicketException(id);
            }
            if (ticket.isExpired()) {
                FunctionUtils.doUnchecked(s -> this.deleteTicket(id), (Object[])new Object[0]);
                LOGGER.debug("Ticket [{}] has expired and is now deleted from the ticket registry.", (Object)ticket);
                throw new InvalidTicketException(id);
            }
        }
    }

    protected WebApplicationService resolveServiceFromAuthenticationRequest(Service service) {
        return (WebApplicationService)this.configurationContext.getAuthenticationServiceSelectionPlan().resolveService(service, WebApplicationService.class);
    }

    protected boolean isTicketAuthenticityVerified(String ticketId) {
        try {
            if (this.configurationContext.getCipherExecutor() != null) {
                LOGGER.trace("Attempting to decode service ticket [{}] to verify authenticity", (Object)ticketId);
                return !ObjectUtils.isEmpty((Object)this.configurationContext.getCipherExecutor().decode((Object)ticketId));
            }
            return !ObjectUtils.isEmpty((Object)ticketId);
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    public TicketFactory getTicketFactory() {
        return this.configurationContext.getTicketFactory();
    }

    @Generated
    protected AbstractCentralAuthenticationService(CentralAuthenticationServiceContext configurationContext) {
        this.configurationContext = configurationContext;
    }
}

