/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jdbc.JdbcAuthenticationProperties;
import org.apereo.cas.discovery.CasServerDiscoveryProfileEndpoint;
import org.apereo.cas.discovery.CasServerProfileRegistrar;
import org.apereo.cas.util.spring.BeanContainer;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributeDaoFilter;
import org.pac4j.core.client.Clients;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="CasDiscoveryProfileConfiguration", proxyBeanMethods=false)
public class CasDiscoveryProfileConfiguration {
    private static Set<String> transformAttributes(List<String> attributes) {
        LinkedHashSet<String> attributeSet = new LinkedHashSet<String>(attributes.size());
        CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap(attributes).values().forEach(v -> attributeSet.add(v.toString()));
        return attributeSet;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasServerProfileRegistrar casServerProfileRegistrar(CasConfigurationProperties casProperties, @Qualifier(value="builtClients") ObjectProvider<Clients> builtClients, @Qualifier(value="discoveryProfileAvailableAttributes") BeanContainer<String> discoveryProfileAvailableAttributes, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
        return new CasServerProfileRegistrar(casProperties, (Clients)builtClients.getIfAvailable(), discoveryProfileAvailableAttributes.toSet(), authenticationEventExecutionPlan);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasServerDiscoveryProfileEndpoint discoveryProfileEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="casServerProfileRegistrar") CasServerProfileRegistrar casServerProfileRegistrar) {
        return new CasServerDiscoveryProfileEndpoint(casProperties, casServerProfileRegistrar);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public BeanContainer<String> discoveryProfileAvailableAttributes(CasConfigurationProperties casProperties, @Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository) {
        JdbcAuthenticationProperties jdbcProps;
        List ldapProps;
        LinkedHashSet attributes = new LinkedHashSet(0);
        Set possibleUserAttributeNames = attributeRepository.getPossibleUserAttributeNames(IPersonAttributeDaoFilter.alwaysChoose());
        if (possibleUserAttributeNames != null) {
            attributes.addAll(possibleUserAttributeNames);
        }
        if ((ldapProps = casProperties.getAuthn().getLdap()) != null) {
            ldapProps.forEach(ldap -> {
                attributes.addAll(CasDiscoveryProfileConfiguration.transformAttributes(ldap.getPrincipalAttributeList()));
                attributes.addAll(CasDiscoveryProfileConfiguration.transformAttributes(ldap.getAdditionalAttributes()));
            });
        }
        if ((jdbcProps = casProperties.getAuthn().getJdbc()) != null) {
            jdbcProps.getQuery().forEach(jdbc -> attributes.addAll(CasDiscoveryProfileConfiguration.transformAttributes(jdbc.getPrincipalAttributeList())));
        }
        return BeanContainer.of(attributes);
    }
}

