/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.jpa.JpaPersistenceProviderConfigurer;
import org.apereo.cas.services.JpaRegisteredServiceEntity;
import org.apereo.cas.services.JpaServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.BeanContainer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement
@Configuration(value="JpaServiceRegistryConfiguration", proxyBeanMethods=false)
@ConditionalOnProperty(prefix="cas.service-registry.jpa", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class JpaServiceRegistryConfiguration {

    @Configuration(value="JpaServiceRegistryBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryBaseConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jpaServiceRegistry"})
        public ServiceRegistry jpaServiceRegistry(ConfigurableApplicationContext applicationContext, ObjectProvider<List<ServiceRegistryListener>> serviceRegistryListeners, @Qualifier(value="jdbcServiceRegistryTransactionTemplate") TransactionTemplate jdbcServiceRegistryTransactionTemplate) {
            return new JpaServiceRegistry(applicationContext, Optional.ofNullable((List)serviceRegistryListeners.getIfAvailable()).orElseGet(ArrayList::new), jdbcServiceRegistryTransactionTemplate);
        }
    }

    @Configuration(value="JpaServiceRegistryDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryDataConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"dataSourceService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource dataSourceService(CasConfigurationProperties casProperties) {
            return JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getServiceRegistry().getJpa());
        }
    }

    @Configuration(value="JpaServiceRegistryTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryTransactionConfiguration {
        @Bean
        public PlatformTransactionManager transactionManagerServiceReg(@Qualifier(value="serviceEntityManagerFactory") EntityManagerFactory emf) {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory(emf);
            return mgmr;
        }

        @ConditionalOnMissingBean(name={"jdbcServiceRegistryTransactionTemplate"})
        @Bean
        public TransactionTemplate jdbcServiceRegistryTransactionTemplate(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            TransactionTemplate t = new TransactionTemplate((PlatformTransactionManager)applicationContext.getBean("transactionManagerServiceReg", PlatformTransactionManager.class));
            t.setIsolationLevelName(casProperties.getServiceRegistry().getJpa().getIsolationLevelName());
            t.setPropagationBehaviorName(casProperties.getServiceRegistry().getJpa().getPropagationBehaviorName());
            return t;
        }
    }

    @Configuration(value="JpaServiceRegistryEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryEntityConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaServiceVendorAdapter(CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc());
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PersistenceProvider jpaServicePersistenceProvider(CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return jpaBeanFactory.newPersistenceProvider((AbstractJpaProperties)casProperties.getServiceRegistry().getJpa());
        }

        @Bean
        @ConditionalOnMissingBean(name={"jpaServicePackagesToScan"})
        public BeanContainer<String> jpaServicePackagesToScan() {
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)JpaRegisteredServiceEntity.class.getPackage().getName()));
        }

        @Bean
        public LocalContainerEntityManagerFactoryBean serviceEntityManagerFactory(CasConfigurationProperties casProperties, @Qualifier(value="dataSourceService") DataSource dataSourceService, @Qualifier(value="jpaServiceVendorAdapter") JpaVendorAdapter jpaServiceVendorAdapter, @Qualifier(value="jpaServicePersistenceProvider") PersistenceProvider jpaServicePersistenceProvider, @Qualifier(value="jpaServicePackagesToScan") BeanContainer<String> jpaServicePackagesToScan, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().dataSource(dataSourceService).persistenceUnitName("jpaServiceRegistryContext").jpaVendorAdapter(jpaServiceVendorAdapter).persistenceProvider(jpaServicePersistenceProvider).packagesToScan(jpaServicePackagesToScan.toSet()).build();
            return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getServiceRegistry().getJpa());
        }
    }

    @Configuration(value="JpaServiceRegistryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"jpaServiceRegistryExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceRegistryExecutionPlanConfigurer jpaServiceRegistryExecutionPlanConfigurer(@Qualifier(value="jpaServiceRegistry") ServiceRegistry jpaServiceRegistry) {
            return plan -> plan.registerServiceRegistry(jpaServiceRegistry);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jpaServicePersistenceProviderConfigurer"})
        public JpaPersistenceProviderConfigurer jpaServicePersistenceProviderConfigurer() {
            return context -> {
                List entities = CollectionUtils.wrapList((Object[])new String[]{JpaRegisteredServiceEntity.class.getName()});
                context.getIncludeEntityClasses().addAll(entities);
            };
        }
    }
}

