/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlanConfigurer;
import org.apereo.cas.throttle.ThrottledRequestFilter;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="OidcThrottleConfiguration", proxyBeanMethods=false)
@AutoConfigureOrder(value=0x7FFFFFFF)
@ConditionalOnBean(name={"authenticationThrottlingExecutionPlan"})
public class OidcThrottleConfiguration {

    @Configuration(value="OidcThrottleFilterConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcThrottleFilterConfiguration {
        private static final List<String> THROTTLED_ENDPOINTS = List.of("oidcAccessToken", "oidcAuthorize", "oidcToken", "oidcProfile", "jwks", "clientConfig", "revoke", "introspect");

        @Bean
        @ConditionalOnMissingBean(name={"oidcThrottledRequestFilter"})
        public ThrottledRequestFilter oidcThrottledRequestFilter(@Qualifier(value="oidcRequestSupport") OidcRequestSupport oidcRequestSupport) {
            return (request, response) -> {
                JEEContext webContext = new JEEContext(request, response);
                return THROTTLED_ENDPOINTS.stream().anyMatch(endpoint -> oidcRequestSupport.isValidIssuerForEndpoint((WebContext)webContext, endpoint));
            };
        }
    }

    @Configuration(value="OidcThrottleExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcThrottleExecutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"oidcAuthenticationThrottlingExecutionPlanConfigurer"})
        @Bean
        public AuthenticationThrottlingExecutionPlanConfigurer oidcAuthenticationThrottlingExecutionPlanConfigurer(@Qualifier(value="oidcThrottledRequestFilter") ThrottledRequestFilter oidcThrottledRequestFilter) {
            return plan -> plan.registerAuthenticationThrottleFilter(oidcThrottledRequestFilter);
        }
    }

    @Configuration(value="OidcThrottleWebMvcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcThrottleWebMvcConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oidcThrottleWebMvcConfigurer"})
        public WebMvcConfigurer oidcThrottleWebMvcConfigurer(ConfigurableApplicationContext applicationContext, final @Qualifier(value="authenticationThrottlingExecutionPlan") AuthenticationThrottlingExecutionPlan authenticationThrottlingExecutionPlan) {
            return new WebMvcConfigurer(){

                public void addInterceptors(InterceptorRegistry registry) {
                    List interceptors = authenticationThrottlingExecutionPlan.getAuthenticationThrottleInterceptors();
                    interceptors.forEach(handler -> registry.addInterceptor(handler).order(0).addPathPatterns(new String[]{"/oidc/**"}));
                }
            };
        }
    }
}

