/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.model.support.oidc.jwks.MongoDbOidcJsonWebKeystoreProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeyStoreListener;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.generator.OidcDefaultJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcGroovyJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreEntity;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcRestfulJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.jpa.OidcJpaJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.mongo.OidcMongoDbJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.rotation.OidcDefaultJsonWebKeystoreRotationService;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.BeanContainer;
import org.apereo.cas.util.spring.CasEventListener;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration(value="OidcJwksConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcJwksConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJwksConfiguration.class);

    @Configuration(value="OidcEndpointsJwksGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcEndpointsJwksGeneratorConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oidcDefaultJsonWebKeystoreCacheLoader"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CacheLoader<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcDefaultJsonWebKeystoreCacheLoader(@Qualifier(value="oidcJsonWebKeystoreGeneratorService") OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService) {
            return new OidcDefaultJsonWebKeystoreCacheLoader(oidcJsonWebKeystoreGeneratorService);
        }

        @ConditionalOnMissingBean(name={"oidcJsonWebKeyStoreListener"})
        @Bean
        public CasEventListener oidcJsonWebKeyStoreListener(@Qualifier(value="oidcDefaultJsonWebKeystoreCache") LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcDefaultJsonWebKeystoreCache) {
            return new OidcDefaultJsonWebKeyStoreListener(oidcDefaultJsonWebKeystoreCache);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcDefaultJsonWebKeystoreCache"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcDefaultJsonWebKeystoreCache(@Qualifier(value="oidcDefaultJsonWebKeystoreCacheLoader") CacheLoader<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> oidcDefaultJsonWebKeystoreCacheLoader, CasConfigurationProperties casProperties) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            Duration expiration = Beans.newDuration((String)oidc.getJwks().getCore().getJwksCacheExpiration());
            return Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(expiration).build(oidcDefaultJsonWebKeystoreCacheLoader);
        }

        @Bean(initMethod="generate")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreGeneratorService"})
        public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            return new OidcDefaultJsonWebKeystoreGeneratorService(oidc, applicationContext);
        }
    }

    @Configuration(value="OidcEndpointsJwksRotationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class OidcEndpointsJwksRotationConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreRotationService"})
        public OidcJsonWebKeystoreRotationService oidcJsonWebKeystoreRotationService(@Qualifier(value="oidcJsonWebKeystoreGeneratorService") OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService, CasConfigurationProperties casProperties) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            return new OidcDefaultJsonWebKeystoreRotationService(oidc, oidcJsonWebKeystoreGeneratorService);
        }

        @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreRotationScheduler"})
        @Bean
        @ConditionalOnProperty(prefix="cas.authn.oidc.jwks.rotation.schedule", name={"enabled"}, havingValue="true", matchIfMissing=false)
        public Runnable oidcJsonWebKeystoreRotationScheduler(@Qualifier(value="oidcJsonWebKeystoreRotationService") OidcJsonWebKeystoreRotationService oidcJsonWebKeystoreRotationService) {
            return new OidcJsonWebKeystoreRotationScheduler(oidcJsonWebKeystoreRotationService);
        }

        @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreRevocationScheduler"})
        @Bean
        @ConditionalOnProperty(prefix="cas.authn.oidc.jwks.revocation.schedule", name={"enabled"}, havingValue="true", matchIfMissing=false)
        public Runnable oidcJsonWebKeystoreRevocationScheduler(@Qualifier(value="oidcJsonWebKeystoreRotationService") OidcJsonWebKeystoreRotationService oidcJsonWebKeystoreRotationService) {
            return new OidcJsonWebKeystoreRevocationScheduler(oidcJsonWebKeystoreRotationService);
        }

        public static class OidcJsonWebKeystoreRevocationScheduler
        implements Runnable {
            @Generated
            private static final Logger LOGGER = LoggerFactory.getLogger(OidcJsonWebKeystoreRevocationScheduler.class);
            private final OidcJsonWebKeystoreRotationService rotationService;

            @Override
            @Scheduled(initialDelayString="${cas.authn.oidc.jwks.revocation.schedule.start-delay:PT60S}", fixedDelayString="${cas.authn.oidc.jwks.revocation.schedule.repeat-interval:P14D}")
            public void run() {
                FunctionUtils.doUnchecked(ig -> {
                    LOGGER.info("Starting to revoke keys in the OIDC keystore...");
                    this.rotationService.revoke();
                }, (Object[])new Object[0]);
            }

            @Generated
            public OidcJsonWebKeystoreRevocationScheduler(OidcJsonWebKeystoreRotationService rotationService) {
                this.rotationService = rotationService;
            }
        }

        public static class OidcJsonWebKeystoreRotationScheduler
        implements Runnable {
            @Generated
            private static final Logger LOGGER = LoggerFactory.getLogger(OidcJsonWebKeystoreRotationScheduler.class);
            private final OidcJsonWebKeystoreRotationService rotationService;

            @Override
            @Scheduled(initialDelayString="${cas.authn.oidc.jwks.rotation.schedule.start-delay:PT60S}", fixedDelayString="${cas.authn.oidc.jwks.rotation.schedule.repeat-interval:P90D}")
            public void run() {
                FunctionUtils.doUnchecked(ig -> {
                    LOGGER.info("Starting to rotate keys in the OIDC keystore...");
                    this.rotationService.rotate();
                }, (Object[])new Object[0]);
            }

            @Generated
            public OidcJsonWebKeystoreRotationScheduler(OidcJsonWebKeystoreRotationService rotationService) {
                this.rotationService = rotationService;
            }
        }
    }

    @Configuration(value="OidcEndpointsJwksGroovyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnProperty(name={"cas.authn.oidc.jwks.groovy.location"})
    public static class OidcEndpointsJwksGroovyConfiguration {
        @Bean(initMethod="generate")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService(CasConfigurationProperties casProperties) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            return new OidcGroovyJsonWebKeystoreGeneratorService(oidc.getJwks().getGroovy().getLocation());
        }
    }

    @Configuration(value="OidcEndpointsJwksRestConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnProperty(name={"cas.authn.oidc.jwks.rest.url"})
    public static class OidcEndpointsJwksRestConfiguration {
        @Bean(initMethod="generate")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService(CasConfigurationProperties casProperties) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            return new OidcRestfulJsonWebKeystoreGeneratorService(oidc);
        }
    }

    @Configuration(value="OidcEndpointsJwksJpaConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={JpaBeanFactory.class})
    @ConditionalOnProperty(name={"cas.authn.oidc.jwks.jpa.url"})
    public static class OidcEndpointsJwksJpaConfiguration {
        @Bean
        public PlatformTransactionManager transactionManagerOidcJwks(@Qualifier(value="oidcJwksEntityManagerFactory") EntityManagerFactory emf) {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory(emf);
            return mgmr;
        }

        @Bean
        public LocalContainerEntityManagerFactoryBean oidcJwksEntityManagerFactory(@Qualifier(value="jpaOidcJwksVendorAdapter") JpaVendorAdapter jpaOidcJwksVendorAdapter, @Qualifier(value="dataSourceOidcJwks") DataSource dataSourceOidcJwks, @Qualifier(value="jpaOidcJwksPackagesToScan") BeanContainer<String> jpaOidcJwksPackagesToScan, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory, CasConfigurationProperties casProperties) {
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(jpaOidcJwksVendorAdapter).persistenceUnitName("jpaOidcJwksContext").dataSource(dataSourceOidcJwks).packagesToScan(jpaOidcJwksPackagesToScan.toSet()).build();
            return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getAuthn().getOidc().getJwks().getJpa());
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaOidcJwksVendorAdapter(@Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory, CasConfigurationProperties casProperties) {
            return jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc());
        }

        @Bean
        public BeanContainer<String> jpaOidcJwksPackagesToScan() {
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)OidcJsonWebKeystoreEntity.class.getPackage().getName()));
        }

        @Bean
        @ConditionalOnMissingBean(name={"dataSourceOidcJwks"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource dataSourceOidcJwks(CasConfigurationProperties casProperties) {
            return JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getAuthn().getOidc().getJwks().getJpa());
        }

        @Bean(initMethod="generate")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService(@Qualifier(value="transactionManagerOidcJwks") PlatformTransactionManager transactionManagerOidcJwks, CasConfigurationProperties casProperties) {
            OidcProperties oidc = casProperties.getAuthn().getOidc();
            LOGGER.info("Managing JWKS via a relational database at [{}]", (Object)oidc.getJwks().getJpa().getUrl());
            TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManagerOidcJwks);
            return new OidcJpaJsonWebKeystoreGeneratorService(oidc, transactionTemplate);
        }
    }

    @Configuration(value="OidcEndpointsJwksMongoDbConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={MongoTemplate.class})
    @ConditionalOnProperty(prefix="cas.authn.oidc.jwks.mongo", name={"host", "collection"})
    public static class OidcEndpointsJwksMongoDbConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public MongoTemplate mongoOidcJsonWebKeystoreTemplate(CasConfigurationProperties casProperties, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
            MongoDbOidcJsonWebKeystoreProperties mongo = casProperties.getAuthn().getOidc().getJwks().getMongo();
            MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
            MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
            MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getCollection(), (boolean)mongo.isDropCollection());
            return mongoTemplate;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService(CasConfigurationProperties casProperties, @Qualifier(value="mongoOidcJsonWebKeystoreTemplate") MongoTemplate mongoOidcJsonWebKeystoreTemplate) {
            return new OidcMongoDbJsonWebKeystoreGeneratorService(mongoOidcJsonWebKeystoreTemplate, casProperties.getAuthn().getOidc());
        }
    }
}

