/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j;

import jakarta.servlet.http.HttpSession;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.apereo.cas.web.BrowserSessionStorage;
import org.apereo.cas.web.DefaultBrowserSessionStorage;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.session.JEESessionStore;

public class BrowserWebStorageSessionStore
extends JEESessionStore {
    private final CipherExecutor webflowCipherExecutor;
    private Map<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();

    public Optional<Object> getTrackableSession(WebContext context) {
        Optional currentSession = super.getTrackableSession(context);
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        currentSession.map(HttpSession.class::cast).ifPresent(session -> {
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = session.getAttribute(name);
                if (value == null) continue;
                attributes.put(name, value);
            }
        });
        attributes.putAll(this.sessionAttributes);
        byte[] encoded = SerializationUtils.serializeAndEncodeObject((CipherExecutor)this.webflowCipherExecutor, attributes);
        String trackableSession = new String(encoded, StandardCharsets.UTF_8);
        return Optional.of(DefaultBrowserSessionStorage.builder().payload(trackableSession).build());
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        byte[] byArray;
        if (trackableSession instanceof BrowserSessionStorage) {
            BrowserSessionStorage storage = (BrowserSessionStorage)trackableSession;
            byArray = storage.getPayload().getBytes(StandardCharsets.UTF_8);
        } else {
            byArray = trackableSession.toString().getBytes(StandardCharsets.UTF_8);
        }
        byte[] encoded = byArray;
        Map attributes = (Map)((Object)SerializationUtils.decodeAndDeserializeObject((byte[])encoded, (CipherExecutor)this.webflowCipherExecutor, LinkedHashMap.class));
        attributes.forEach((key, value) -> this.set(context, (String)key, value));
        this.sessionAttributes.putAll(attributes);
        return Optional.of(this);
    }

    @Generated
    public BrowserWebStorageSessionStore(CipherExecutor webflowCipherExecutor) {
        this.webflowCipherExecutor = webflowCipherExecutor;
    }

    @Generated
    public CipherExecutor getWebflowCipherExecutor() {
        return this.webflowCipherExecutor;
    }

    @Generated
    public Map<String, Object> getSessionAttributes() {
        return this.sessionAttributes;
    }

    @Generated
    public BrowserWebStorageSessionStore setSessionAttributes(Map<String, Object> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
        return this;
    }
}

