/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationDiscoverySelectionProperties;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationRequestCustomizer;
import org.apereo.cas.pac4j.client.DelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.validation.DelegatedAuthenticationAccessStrategyHelper;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfiguration;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfigurationFactory;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.RequestContext;

public class DefaultDelegatedClientIdentityProviderConfigurationProducer
implements DelegatedClientIdentityProviderConfigurationProducer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedClientIdentityProviderConfigurationProducer.class);
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final Clients clients;
    private final DelegatedAuthenticationAccessStrategyHelper delegatedAuthenticationAccessStrategyHelper;
    private final CasConfigurationProperties casProperties;
    private final List<DelegatedClientAuthenticationRequestCustomizer> delegatedClientAuthenticationRequestCustomizers;
    private final DelegatedClientIdentityProviderRedirectionStrategy delegatedClientIdentityProviderRedirectionStrategy;

    public Set<DelegatedClientIdentityProviderConfiguration> produce(RequestContext context) {
        WebApplicationService currentService = WebUtils.getService((RequestContext)context);
        WebApplicationService service = (WebApplicationService)this.authenticationRequestServiceSelectionStrategies.resolveService((Service)currentService, WebApplicationService.class);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        JEEContext webContext = new JEEContext(request, response);
        LOGGER.debug("Initialized context with request parameters [{}]", (Object)webContext.getRequestParameters());
        List allClients = this.clients.findAllClients();
        LinkedHashSet<DelegatedClientIdentityProviderConfiguration> providers = new LinkedHashSet<DelegatedClientIdentityProviderConfiguration>(allClients.size());
        allClients.stream().filter(client -> client instanceof IndirectClient && this.isDelegatedClientAuthorizedForService((Client)client, (Service)service, request)).map(IndirectClient.class::cast).forEach(client -> {
            try {
                Optional<DelegatedClientIdentityProviderConfiguration> providerResult = this.produce(context, (IndirectClient)client);
                providerResult.ifPresent(provider -> {
                    providers.add((DelegatedClientIdentityProviderConfiguration)provider);
                    this.delegatedClientIdentityProviderRedirectionStrategy.getPrimaryDelegatedAuthenticationProvider(context, service, provider).ifPresent(p -> WebUtils.putDelegatedAuthenticationProviderPrimary((RequestContext)context, (Object)p));
                });
            }
            catch (Exception e) {
                LOGGER.error("Cannot process client [{}]", client);
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
        });
        if (!providers.isEmpty()) {
            Pac4jDelegatedAuthenticationDiscoverySelectionProperties.Pac4jDelegatedAuthenticationSelectionTypes selectionType = this.casProperties.getAuthn().getPac4j().getCore().getDiscoverySelection().getSelectionType();
            switch (selectionType) {
                case DYNAMIC: {
                    WebUtils.putDelegatedAuthenticationProviderConfigurations((RequestContext)context, new HashSet());
                    WebUtils.putDelegatedAuthenticationDynamicProviderSelection((RequestContext)context, (Boolean)Boolean.TRUE);
                    break;
                }
                default: {
                    WebUtils.putDelegatedAuthenticationProviderConfigurations((RequestContext)context, providers);
                    WebUtils.putDelegatedAuthenticationDynamicProviderSelection((RequestContext)context, (Boolean)Boolean.FALSE);
                    break;
                }
            }
        } else if (response.getStatus() != HttpStatus.UNAUTHORIZED.value()) {
            LOGGER.warn("No delegated authentication providers could be determined based on the provided configuration. Either no clients are configured, or the current access strategy rules prohibit CAS from using authentication providers");
        }
        return providers;
    }

    public Optional<DelegatedClientIdentityProviderConfiguration> produce(RequestContext requestContext, IndirectClient client) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext webContext = new JEEContext(request, response);
        WebApplicationService currentService = WebUtils.getService((RequestContext)requestContext);
        LOGGER.debug("Initializing client [{}] with request parameters [{}] and service [{}]", new Object[]{client, requestContext.getRequestParameters(), currentService});
        client.init();
        if (!client.isInitialized()) {
            LOGGER.warn("Unable to initialize client [{}]. Verify the client configuration details.", (Object)client.getName());
            return Optional.empty();
        }
        if (this.delegatedClientAuthenticationRequestCustomizers.isEmpty() || this.delegatedClientAuthenticationRequestCustomizers.stream().anyMatch(c -> c.isAuthorized(webContext, client, currentService))) {
            return DelegatedClientIdentityProviderConfigurationFactory.builder().client(client).webContext((WebContext)webContext).service(currentService).casProperties(this.casProperties).build().resolve();
        }
        return Optional.empty();
    }

    private boolean isDelegatedClientAuthorizedForService(Client client, Service service, HttpServletRequest request) {
        return this.delegatedAuthenticationAccessStrategyHelper.isDelegatedClientAuthorizedForService(client, service, request);
    }

    @Generated
    public DefaultDelegatedClientIdentityProviderConfigurationProducer(AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, Clients clients, DelegatedAuthenticationAccessStrategyHelper delegatedAuthenticationAccessStrategyHelper, CasConfigurationProperties casProperties, List<DelegatedClientAuthenticationRequestCustomizer> delegatedClientAuthenticationRequestCustomizers, DelegatedClientIdentityProviderRedirectionStrategy delegatedClientIdentityProviderRedirectionStrategy) {
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.clients = clients;
        this.delegatedAuthenticationAccessStrategyHelper = delegatedAuthenticationAccessStrategyHelper;
        this.casProperties = casProperties;
        this.delegatedClientAuthenticationRequestCustomizers = delegatedClientAuthenticationRequestCustomizers;
        this.delegatedClientIdentityProviderRedirectionStrategy = delegatedClientIdentityProviderRedirectionStrategy;
    }
}

