/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.pac4j.discovery.DelegatedAuthenticationDynamicDiscoveryProviderLocator;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.pac4j.core.client.IndirectClient;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientAuthenticationDynamicDiscoveryExecutionAction
extends BaseCasWebflowAction {
    public static final String REQUEST_SCOPE_ATTR_PROVIDER_REDIRECT_URL = "delegatedAuthProviderRedirectUrl";
    private final DelegatedClientAuthenticationConfigurationContext configContext;
    private final DelegatedAuthenticationDynamicDiscoveryProviderLocator selector;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        String userid = requestContext.getRequestParameters().get("username");
        DelegatedAuthenticationDynamicDiscoveryProviderLocator.DynamicDiscoveryProviderRequest request = DelegatedAuthenticationDynamicDiscoveryProviderLocator.DynamicDiscoveryProviderRequest.builder().userId(userid).build();
        Optional client = this.selector.locate(request);
        if (client.isEmpty()) {
            MessageResolver msg = new MessageBuilder().error().code("screen.pac4j.discovery.unknownclient").build();
            requestContext.getMessageContext().addMessage(msg);
            requestContext.getRequestScope().put("username", (Object)userid);
            return this.error();
        }
        this.configContext.getDelegatedClientIdentityProvidersProducer().produce(requestContext, (IndirectClient)client.get()).ifPresent(cfg -> requestContext.getRequestScope().put(REQUEST_SCOPE_ATTR_PROVIDER_REDIRECT_URL, (Object)cfg.getRedirectUrl()));
        return new Event((Object)this, "redirect", (AttributeMap)new LocalAttributeMap("client", client.get()));
    }

    @Generated
    public DelegatedClientAuthenticationDynamicDiscoveryExecutionAction(DelegatedClientAuthenticationConfigurationContext configContext, DelegatedAuthenticationDynamicDiscoveryProviderLocator selector) {
        this.configContext = configContext;
        this.selector = selector;
    }
}

