/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.DelegatedAuthenticationAuditResourceResolver;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.provision.ChainingDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.GroovyDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.RestfulDelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCoreProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProvisioningProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationRestfulProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.pac4j.DistributedJEESessionStore;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.pac4j.RefreshableDelegatedClients;
import org.apereo.cas.support.pac4j.authentication.ClientAuthenticationMetaDataPopulator;
import org.apereo.cas.support.pac4j.authentication.DefaultDelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.DelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.DelegatedClientFactoryCustomizer;
import org.apereo.cas.support.pac4j.authentication.RestfulDelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.handler.support.DelegatedClientAuthenticationHandler;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="Pac4jAuthenticationEventExecutionPlanConfiguration", proxyBeanMethods=false)
public class Pac4jAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jAuthenticationEventExecutionPlanConfiguration.class);

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanBaseConfiguration {
        @ConditionalOnMissingBean(name={"pac4jAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer pac4jAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="builtClients") Clients builtClients, @Qualifier(value="clientAuthenticationHandler") AuthenticationHandler clientAuthenticationHandler, @Qualifier(value="clientAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator clientAuthenticationMetaDataPopulator, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
            return plan -> {
                if (!builtClients.findAllClients().isEmpty()) {
                    LOGGER.info("Registering delegated authentication clients...");
                    plan.registerAuthenticationHandlerWithPrincipalResolver(clientAuthenticationHandler, defaultPrincipalResolver);
                    plan.registerAuthenticationMetadataPopulator(clientAuthenticationMetaDataPopulator);
                }
            };
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanLogoutConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanLogoutConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedAuthenticationLogoutExecutionPlanConfigurer"})
        public LogoutExecutionPlanConfigurer delegatedAuthenticationLogoutExecutionPlanConfigurer(CasConfigurationProperties casProperties, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore) {
            return plan -> {
                boolean replicate = casProperties.getAuthn().getPac4j().getCore().isReplicateSessions();
                if (replicate) {
                    plan.registerLogoutPostProcessor(ticketGrantingTicket -> {
                        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
                        HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
                        if (request != null && response != null) {
                            delegatedClientDistributedSessionStore.destroySession((WebContext)new JEEContext(request, response));
                        }
                    });
                }
            };
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanAuditPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanAuditPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"delegatedAuthenticationAuditTrailRecordResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer delegatedAuthenticationAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="delegatedAuthenticationAuditResourceResolver") AuditResourceResolver delegatedAuthenticationAuditResourceResolver, @Qualifier(value="authenticationActionResolver") AuditActionResolver authenticationActionResolver) {
            return plan -> {
                plan.registerAuditActionResolver("DELEGATED_CLIENT_ACTION_RESOLVER", authenticationActionResolver);
                plan.registerAuditResourceResolver("DELEGATED_CLIENT_RESOURCE_RESOLVER", delegatedAuthenticationAuditResourceResolver);
            };
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanAuditConfiguration {
        @ConditionalOnMissingBean(name={"delegatedAuthenticationAuditResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver delegatedAuthenticationAuditResourceResolver() {
            return new DelegatedAuthenticationAuditResourceResolver();
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanClientConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"builtClients"})
        public Clients builtClients(CasConfigurationProperties casProperties, @Qualifier(value="pac4jDelegatedClientFactory") DelegatedClientFactory pac4jDelegatedClientFactory) {
            return new RefreshableDelegatedClients(casProperties.getServer().getLoginUrl(), pac4jDelegatedClientFactory);
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanClientFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanClientFactoryConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"pac4jDelegatedClientFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedClientFactory pac4jDelegatedClientFactory(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<List<DelegatedClientFactoryCustomizer>> customizerList, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
            Pac4jDelegatedAuthenticationRestfulProperties rest = casProperties.getAuthn().getPac4j().getRest();
            if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
                return new RestfulDelegatedClientFactory(casProperties);
            }
            List customizers = Optional.ofNullable((List)customizerList.getIfAvailable()).map(result -> {
                AnnotationAwareOrderComparator.sortIfNecessary((Object)result);
                return result;
            }).orElseGet(() -> new ArrayList(0));
            return new DefaultDelegatedClientFactory(casProperties, (Collection)customizers, casSslContext, (ApplicationContext)applicationContext);
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanProvisionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanProvisionConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"clientUserProfileProvisioner"})
        public DelegatedClientUserProfileProvisioner clientUserProfileProvisioner(ObjectProvider<List<Supplier<DelegatedClientUserProfileProvisioner>>> provisioners) {
            List results = ((List)provisioners.getIfAvailable(() -> CollectionUtils.wrapList((Object[])new Supplier[]{DelegatedClientUserProfileProvisioner::noOp}))).stream().map(Supplier::get).collect(Collectors.toList());
            return new ChainingDelegatedClientUserProfileProvisioner(results);
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanProvisionerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanProvisionerConfiguration {
        @Bean
        @ConditionalOnProperty(name={"cas.authn.pac4j.provisioning.groovy.location"})
        @ConditionalOnMissingBean(name={"groovyDelegatedClientUserProfileProvisioner"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Supplier<DelegatedClientUserProfileProvisioner> groovyDelegatedClientUserProfileProvisioner(CasConfigurationProperties casProperties) {
            Pac4jDelegatedAuthenticationProvisioningProperties provisioning = casProperties.getAuthn().getPac4j().getProvisioning();
            Resource script = provisioning.getGroovy().getLocation();
            return () -> new GroovyDelegatedClientUserProfileProvisioner(script);
        }

        @Bean
        @ConditionalOnProperty(name={"cas.authn.pac4j.provisioning.rest.url"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"restDelegatedClientUserProfileProvisioner"})
        public Supplier<DelegatedClientUserProfileProvisioner> restDelegatedClientUserProfileProvisioner(CasConfigurationProperties casProperties) {
            Pac4jDelegatedAuthenticationProvisioningProperties provisioning = casProperties.getAuthn().getPac4j().getProvisioning();
            return () -> new RestfulDelegatedClientUserProfileProvisioner((RestEndpointProperties)provisioning.getRest());
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanHandlerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanHandlerConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"clientAuthenticationHandler"})
        public AuthenticationHandler clientAuthenticationHandler(CasConfigurationProperties casProperties, @Qualifier(value="clientPrincipalFactory") PrincipalFactory clientPrincipalFactory, @Qualifier(value="builtClients") Clients builtClients, @Qualifier(value="clientUserProfileProvisioner") DelegatedClientUserProfileProvisioner clientUserProfileProvisioner, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            Pac4jDelegatedAuthenticationCoreProperties pac4j = casProperties.getAuthn().getPac4j().getCore();
            DelegatedClientAuthenticationHandler h = new DelegatedClientAuthenticationHandler(pac4j.getName(), pac4j.getOrder(), servicesManager, clientPrincipalFactory, builtClients, clientUserProfileProvisioner, delegatedClientDistributedSessionStore);
            h.setTypedIdUsed(pac4j.isTypedIdUsed());
            h.setPrincipalAttributeId(pac4j.getPrincipalAttributeId());
            return h;
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanMetadataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanMetadataConfiguration {
        @ConditionalOnMissingBean(name={"clientAuthenticationMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationMetaDataPopulator clientAuthenticationMetaDataPopulator() {
            return new ClientAuthenticationMetaDataPopulator();
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanCoreConfiguration {
        @ConditionalOnMissingBean(name={"delegatedClientDistributedSessionCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder delegatedClientDistributedSessionCookieGenerator(CasConfigurationProperties casProperties) {
            CookieSessionReplicationProperties cookie = casProperties.getSessionReplication().getCookie();
            return CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
        }

        @ConditionalOnMissingBean(name={"clientPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory clientPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanSessionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanSessionConfiguration {
        @ConditionalOnMissingBean(name={"delegatedClientDistributedSessionStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SessionStore delegatedClientDistributedSessionStore(CasConfigurationProperties casProperties, @Qualifier(value="delegatedClientDistributedSessionCookieGenerator") CasCookieBuilder delegatedClientDistributedSessionCookieGenerator, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            boolean replicate = casProperties.getAuthn().getPac4j().getCore().isReplicateSessions();
            if (replicate) {
                return new DistributedJEESessionStore(centralAuthenticationService, ticketFactory, delegatedClientDistributedSessionCookieGenerator);
            }
            return JEESessionStore.INSTANCE;
        }
    }
}

