/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.function.Supplier;
import org.apereo.cas.api.PrincipalProvisioner;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.GroovyDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.RestfulDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.ScimDelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProvisioningProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="Pac4jAuthenticationProvisioningConfiguration", proxyBeanMethods=false)
public class Pac4jAuthenticationProvisioningConfiguration {

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanProvisionerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanProvisionerConfiguration {
        @Bean
        @ConditionalOnProperty(name={"cas.authn.pac4j.provisioning.groovy.location"})
        @ConditionalOnMissingBean(name={"groovyDelegatedClientUserProfileProvisioner"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Supplier<DelegatedClientUserProfileProvisioner> groovyDelegatedClientUserProfileProvisioner(CasConfigurationProperties casProperties) {
            Pac4jDelegatedAuthenticationProvisioningProperties provisioning = casProperties.getAuthn().getPac4j().getProvisioning();
            Resource script = provisioning.getGroovy().getLocation();
            return () -> new GroovyDelegatedClientUserProfileProvisioner(script);
        }

        @Bean
        @ConditionalOnProperty(name={"cas.authn.pac4j.provisioning.rest.url"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"restDelegatedClientUserProfileProvisioner"})
        public Supplier<DelegatedClientUserProfileProvisioner> restDelegatedClientUserProfileProvisioner(CasConfigurationProperties casProperties) {
            Pac4jDelegatedAuthenticationProvisioningProperties provisioning = casProperties.getAuthn().getPac4j().getProvisioning();
            return () -> new RestfulDelegatedClientUserProfileProvisioner((RestEndpointProperties)provisioning.getRest());
        }
    }

    @Configuration(value="Pac4jAuthenticationScimProvisioningConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={PrincipalProvisioner.class})
    @ConditionalOnProperty(prefix="cas.authn.pac4j.provisioning.scim", name={"enabled"}, havingValue="true")
    public static class Pac4jAuthenticationScimProvisioningConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"pac4jScimDelegatedClientUserProfileProvisioner"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Supplier<DelegatedClientUserProfileProvisioner> pac4jScimDelegatedClientUserProfileProvisioner(@Qualifier(value="scimProvisioner") PrincipalProvisioner scimProvisioner) {
            return () -> new ScimDelegatedClientUserProfileProvisioner(scimProvisioner);
        }
    }
}

