/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.attribute.DefaultAttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolutionExecutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.core.authentication.StubPrincipalAttributesProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.persondir.DefaultPersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryCustomizer;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.BeanContainer;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.AbstractAggregatingDefaultQueryPersonAttributeDao;
import org.apereo.services.persondir.support.CachingPersonAttributeDaoImpl;
import org.apereo.services.persondir.support.CascadingPersonAttributeDao;
import org.apereo.services.persondir.support.MergingPersonAttributeDaoImpl;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.Resource;

@Configuration(value="CasPersonDirectoryConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasPersonDirectoryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryConfiguration.class);

    @Configuration(value="CasPersonDirectoryStaticSubAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasPersonDirectoryStaticSubAttributeRepositoryConfiguration {

        @Configuration(value="StubAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
        @EnableConfigurationProperties(value={CasConfigurationProperties.class})
        public static class StubAttributeRepositoryPlanConfiguration {
            @Bean
            @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
            @ConditionalOnMissingBean(name={"stubPersonDirectoryAttributeRepositoryPlanConfigurer"})
            public PersonDirectoryAttributeRepositoryPlanConfigurer stubPersonDirectoryAttributeRepositoryPlanConfigurer(@Qualifier(value="stubAttributeRepositories") BeanContainer<IPersonAttributeDao> stubAttributeRepositories) {
                return plan -> {
                    List results = stubAttributeRepositories.toList().stream().filter(repo -> (Boolean)repo.getTags().get("state")).collect(Collectors.toList());
                    plan.registerAttributeRepositories(results);
                };
            }
        }

        @Configuration(value="StubAttributeRepositoryConfiguration", proxyBeanMethods=false)
        @EnableConfigurationProperties(value={CasConfigurationProperties.class})
        public static class StubAttributeRepositoryConfiguration {
            @ConditionalOnMissingBean(name={"stubAttributeRepositories"})
            @Bean
            @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
            public BeanContainer<IPersonAttributeDao> stubAttributeRepositories(CasConfigurationProperties casProperties) {
                ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
                StubPrincipalAttributesProperties stub = casProperties.getAuthn().getAttributeRepository().getStub();
                Map attrs = stub.getAttributes();
                if (!attrs.isEmpty()) {
                    IPersonAttributeDao dao = Beans.newStubAttributeRepository((PrincipalAttributesProperties)casProperties.getAuthn().getAttributeRepository());
                    list.add(dao);
                }
                return BeanContainer.of(list);
            }
        }
    }

    @Configuration(value="CasPersonDirectoryAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasPersonDirectoryAttributeRepositoryConfiguration {
        private static AbstractAggregatingDefaultQueryPersonAttributeDao getAggregateAttributeRepository(CasConfigurationProperties casProperties) {
            PrincipalAttributesProperties properties = casProperties.getAuthn().getAttributeRepository();
            switch (properties.getCore().getAggregation()) {
                case CASCADE: {
                    CascadingPersonAttributeDao dao = new CascadingPersonAttributeDao();
                    dao.setAddOriginalAttributesToQuery(true);
                    dao.setStopIfFirstDaoReturnsNull(true);
                    return dao;
                }
            }
            return new MergingPersonAttributeDaoImpl();
        }

        @Bean(name={"cachingAttributeRepository", "attributeRepository"})
        @ConditionalOnMissingBean(name={"cachingAttributeRepository", "attributeRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public IPersonAttributeDao cachingAttributeRepository(CasConfigurationProperties casProperties, @Qualifier(value="aggregatingAttributeRepository") IPersonAttributeDao aggregatingAttributeRepository) {
            PrincipalAttributesCoreProperties props = casProperties.getAuthn().getAttributeRepository().getCore();
            if (props.getExpirationTime() <= 0) {
                LOGGER.warn("Attribute repository caching is disabled");
                return aggregatingAttributeRepository;
            }
            CachingPersonAttributeDaoImpl impl = new CachingPersonAttributeDaoImpl();
            impl.setCacheNullResults(false);
            Cache userinfoCache = Caffeine.newBuilder().maximumSize((long)props.getMaximumCacheSize()).expireAfterWrite((long)props.getExpirationTime(), TimeUnit.valueOf(props.getExpirationTimeUnit().toUpperCase())).build();
            impl.setUserInfoCache((Map)userinfoCache.asMap());
            impl.setCachedPersonAttributesDao(aggregatingAttributeRepository);
            LOGGER.trace("Configured cache expiration policy for attribute sources to be [{}] minute(s)", (Object)props.getExpirationTime());
            return impl;
        }

        @Bean
        @ConditionalOnMissingBean(name={"aggregatingAttributeRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public IPersonAttributeDao aggregatingAttributeRepository(CasConfigurationProperties casProperties, @Qualifier(value="personDirectoryAttributeRepositoryPlan") PersonDirectoryAttributeRepositoryPlan personDirectoryAttributeRepositoryPlan) {
            AbstractAggregatingDefaultQueryPersonAttributeDao aggregate = CasPersonDirectoryAttributeRepositoryConfiguration.getAggregateAttributeRepository(casProperties);
            PrincipalAttributesProperties properties = casProperties.getAuthn().getAttributeRepository();
            IAttributeMerger attributeMerger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)properties.getCore().getMerger());
            LOGGER.trace("Configured merging strategy for attribute sources is [{}]", (Object)attributeMerger);
            aggregate.setMerger(attributeMerger);
            List list = personDirectoryAttributeRepositoryPlan.getAttributeRepositories();
            aggregate.setPersonAttributeDaos(list);
            aggregate.setRequireAll(properties.getCore().isRequireAllRepositorySources());
            if (list.isEmpty()) {
                LOGGER.debug("No attribute repository sources are available/defined to merge together.");
            } else {
                String names = list.stream().map(p -> Arrays.toString(p.getId())).collect(Collectors.joining(","));
                LOGGER.debug("Configured attribute repository sources to merge together: [{}]", (Object)names);
            }
            boolean recoverExceptions = properties.getCore().isRecoverExceptions();
            aggregate.setRecoverExceptions(recoverExceptions);
            LOGGER.trace("Configured attribute repository to recover from exceptions: [{}]", (Object)recoverExceptions);
            return aggregate;
        }

        @Bean
        public InitializingBean casPersonDirectoryInitializer(CasConfigurationProperties casProperties) {
            return () -> FunctionUtils.doIf((boolean)LOGGER.isInfoEnabled(), value -> {
                StubPrincipalAttributesProperties stub = casProperties.getAuthn().getAttributeRepository().getStub();
                Map attrs = stub.getAttributes();
                if (!attrs.isEmpty()) {
                    LOGGER.info("Found and added static attributes [{}] to the list of candidate attribute repositories", attrs.keySet());
                }
            }).accept(null);
        }
    }

    @Configuration(value="CasPersonDirectoryAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasPersonDirectoryAttributeRepositoryPlanConfiguration {
        @ConditionalOnMissingBean(name={"personDirectoryAttributeRepositoryPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PersonDirectoryAttributeRepositoryPlan personDirectoryAttributeRepositoryPlan(List<PersonDirectoryAttributeRepositoryPlanConfigurer> configurers, ObjectProvider<List<PersonDirectoryAttributeRepositoryCustomizer>> customizers) {
            DefaultPersonDirectoryAttributeRepositoryPlan plan = new DefaultPersonDirectoryAttributeRepositoryPlan(Optional.ofNullable((List)customizers.getIfAvailable()).orElseGet(ArrayList::new));
            configurers.forEach(c -> c.configureAttributeRepositoryPlan((PersonDirectoryAttributeRepositoryPlan)plan));
            AnnotationAwareOrderComparator.sort((List)plan.getAttributeRepositories());
            LOGGER.trace("Final list of attribute repositories is [{}]", (Object)plan.getAttributeRepositories());
            return plan;
        }
    }

    @Configuration(value="CasPersonDirectoryPrincipalResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasPersonDirectoryPrincipalResolutionConfiguration {
        @ConditionalOnMissingBean(name={"personDirectoryPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory personDirectoryPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"personDirectoryAttributeRepositoryPrincipalResolver"})
        public PrincipalResolver personDirectoryAttributeRepositoryPrincipalResolver(CasConfigurationProperties casProperties, @Qualifier(value="personDirectoryPrincipalFactory") PrincipalFactory personDirectoryPrincipalFactory, @Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository) {
            PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
            IAttributeMerger attributeMerger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
            return CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)personDirectoryPrincipalFactory, (IPersonAttributeDao)attributeRepository, (IAttributeMerger)attributeMerger, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{personDirectory});
        }

        @ConditionalOnMissingBean(name={"principalResolutionExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolutionExecutionPlanConfigurer principalResolutionExecutionPlanConfigurer(@Qualifier(value="personDirectoryAttributeRepositoryPlan") PersonDirectoryAttributeRepositoryPlan personDirectoryAttributeRepositoryPlan, @Qualifier(value="personDirectoryAttributeRepositoryPrincipalResolver") PrincipalResolver personDirectoryAttributeRepositoryPrincipalResolver) {
            return plan -> {
                if (personDirectoryAttributeRepositoryPlan.isEmpty()) {
                    LOGGER.debug("Attribute repository sources are not available for person-directory principal resolution");
                } else {
                    LOGGER.trace("Attribute repository sources are defined and available for person-directory principal resolution chain. ");
                    plan.registerPrincipalResolver(personDirectoryAttributeRepositoryPrincipalResolver);
                }
            };
        }
    }

    @Configuration(value="CasPersonDirectoryAttributeDefinitionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasPersonDirectoryAttributeDefinitionConfiguration {
        @ConditionalOnMissingBean(name={"attributeDefinitionStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AttributeDefinitionStore attributeDefinitionStore(CasConfigurationProperties casProperties) throws Exception {
            Resource resource = casProperties.getAuthn().getAttributeRepository().getAttributeDefinitionStore().getJson().getLocation();
            DefaultAttributeDefinitionStore store = new DefaultAttributeDefinitionStore(resource);
            store.setScope(casProperties.getServer().getScope());
            return store;
        }
    }
}

