/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.spring.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnMultiValuedProperty;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.JsonBackedComplexStubPersonAttributeDao;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;

@ConditionalOnMultiValuedProperty(name="cas.authn.attribute-repository.json[0]", value={"location"})
@Configuration(value="CasPersonDirectoryJsonConfiguration", proxyBeanMethods=false)
public class CasPersonDirectoryJsonConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryJsonConfiguration.class);

    @Configuration(value="JsonAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JsonAttributeRepositoryPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jsonPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer jsonPersonDirectoryAttributeRepositoryPlanConfigurer(@Qualifier(value="jsonAttributeRepositories") BeanContainer<IPersonAttributeDao> jsonAttributeRepositories) {
            return plan -> {
                List results = jsonAttributeRepositories.toList().stream().filter(repo -> (Boolean)repo.getTags().get(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName())).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            };
        }
    }

    @Configuration(value="JsonAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JsonAttributeRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"jsonAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<IPersonAttributeDao> jsonAttributeRepositories(CasConfigurationProperties casProperties) {
            ArrayList list = new ArrayList();
            casProperties.getAuthn().getAttributeRepository().getJson().stream().filter(json -> ResourceUtils.doesResourceExist((Resource)json.getLocation())).forEach(Unchecked.consumer(json -> {
                Resource r = json.getLocation();
                JsonBackedComplexStubPersonAttributeDao dao = new JsonBackedComplexStubPersonAttributeDao(r);
                if (ResourceUtils.isFile((Resource)r)) {
                    FileWatcherService watcherService = new FileWatcherService(r.getFile(), Unchecked.consumer(file -> {
                        Thread.sleep(100L);
                        dao.init();
                    }));
                    watcherService.start(this.getClass().getSimpleName());
                    dao.setResourceWatcherService((Closeable)watcherService);
                }
                dao.setOrder(json.getOrder());
                FunctionUtils.doIfNotNull((Object)json.getId(), xva$0 -> dao.setId(new String[]{xva$0}));
                dao.setEnabled(json.getState() != AttributeRepositoryStates.DISABLED);
                dao.putTag(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName(), (Object)(json.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
                dao.init();
                LOGGER.debug("Configured JSON attribute sources from [{}]", (Object)r);
                list.add(dao);
            }));
            return BeanContainer.of(list);
        }
    }
}

