/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.pm.LdapPasswordManagementProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class LdapPasswordManagementService
extends BasePasswordManagementService
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapPasswordManagementService.class);
    private final List<LdapPasswordManagementProperties> ldapProperties;
    private final Map<String, ConnectionFactory> connectionFactoryMap;

    public LdapPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, PasswordManagementProperties passwordManagementProperties, PasswordHistoryService passwordHistoryService, Map<String, ConnectionFactory> connectionFactoryMap) {
        super(passwordManagementProperties, cipherExecutor, issuer, passwordHistoryService);
        this.ldapProperties = passwordManagementProperties.getLdap();
        this.connectionFactoryMap = connectionFactoryMap;
    }

    public void destroy() {
        this.connectionFactoryMap.forEach((ldap, connectionFactory) -> connectionFactory.close());
    }

    public String findEmail(PasswordManagementQuery query) {
        String email = this.findAttribute(query, List.of(this.properties.getReset().getMail().getAttributeName()), CollectionUtils.wrap((Object)query.getUsername()));
        if (EmailValidator.getInstance().isValid(email)) {
            LOGGER.debug("Email address [{}] for [{}] appears valid", (Object)email, (Object)query.getUsername());
            return email;
        }
        LOGGER.warn("Email address [{}] for [{}] is not valid", (Object)email, (Object)query.getUsername());
        return null;
    }

    public String findPhone(PasswordManagementQuery query) {
        return this.findAttribute(query, List.of(this.properties.getReset().getSms().getAttributeName()), CollectionUtils.wrap((Object)query.getUsername()));
    }

    public String findUsername(PasswordManagementQuery query) {
        return this.findAttribute(query, this.properties.getLdap().stream().map(LdapPasswordManagementProperties::getUsernameAttribute).collect(Collectors.toList()), CollectionUtils.wrap((Object)query.getEmail()));
    }

    public void updateSecurityQuestions(PasswordManagementQuery query) {
        this.findEntries(CollectionUtils.wrap((Object)query.getUsername())).forEach((entry, ldap) -> {
            LOGGER.debug("Located LDAP entry [{}] in the response", entry);
            ArrayDeque questionsAndAnswers = new ArrayDeque(ldap.getSecurityQuestionsAttributes().entrySet());
            LOGGER.debug("Security question attributes are defined to be [{}]", questionsAndAnswers);
            ConnectionFactory ldapConnectionFactory = this.connectionFactoryMap.get(ldap.getLdapUrl());
            LinkedHashMap attributes = new LinkedHashMap();
            query.getSecurityQuestions().forEach((question, answers) -> {
                Map.Entry attrEntry = (Map.Entry)questionsAndAnswers.pop();
                attributes.put((String)attrEntry.getKey(), Set.of(question));
                attributes.put((String)attrEntry.getValue(), Set.copyOf(answers));
            });
            LdapUtils.executeModifyOperation((String)entry.getDn(), (ConnectionFactory)ldapConnectionFactory, attributes);
        });
    }

    public Map<String, String> getSecurityQuestions(PasswordManagementQuery query) {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>(0);
        this.findEntries(CollectionUtils.wrap((Object)query.getUsername())).forEach((entry, ldap) -> {
            LOGGER.debug("Located LDAP entry [{}] in the response", entry);
            Map questionsAndAnswers = ldap.getSecurityQuestionsAttributes();
            LOGGER.debug("Security question attributes are defined to be [{}]", (Object)questionsAndAnswers);
            questionsAndAnswers.forEach((k, v) -> {
                LdapAttribute questionAttribute = entry.getAttribute(k);
                LdapAttribute answerAttribute = entry.getAttribute(v);
                if (questionAttribute != null && answerAttribute != null) {
                    String question = questionAttribute.getStringValue();
                    String answer = answerAttribute.getStringValue();
                    if (StringUtils.isNotBlank((CharSequence)question) && StringUtils.isNotBlank((CharSequence)answer)) {
                        LOGGER.debug("Added security question [{}] with answer [{}]", (Object)question, (Object)answer);
                        results.put(question, answer);
                    }
                }
            });
        });
        return results;
    }

    public boolean changeInternal(Credential credential, PasswordChangeRequest bean) {
        try {
            List results = this.findEntries(CollectionUtils.wrap((Object)credential.getId())).entrySet().stream().map(entry -> {
                String dn = ((LdapEntry)entry.getKey()).getDn();
                LOGGER.debug("Updating account password for [{}]", (Object)dn);
                UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
                ConnectionFactory ldapConnectionFactory = this.connectionFactoryMap.get(((LdapPasswordManagementProperties)entry.getValue()).getLdapUrl());
                if (LdapUtils.executePasswordModifyOperation((String)dn, (ConnectionFactory)ldapConnectionFactory, (String)c.getPassword(), (String)bean.getPassword(), (AbstractLdapProperties.LdapType)((LdapPasswordManagementProperties)entry.getValue()).getType())) {
                    LOGGER.debug("Successfully updated the account password for [{}]", (Object)dn);
                    return Boolean.TRUE;
                }
                LOGGER.error("Could not update the LDAP entry's password for [{}]", (Object)dn);
                return Boolean.FALSE;
            }).collect(Collectors.toList());
            return results.stream().allMatch(result -> result);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    protected String findAttribute(PasswordManagementQuery context, List<String> attributeNames, List<String> ldapFilterParam) {
        return this.findEntries(ldapFilterParam).keySet().stream().map(entry -> {
            LOGGER.debug("Found LDAP entry [{}] to use", entry);
            return attributeNames.stream().map(attributeName -> {
                LdapAttribute attr = entry.getAttribute(attributeName);
                if (attr != null) {
                    String attributeValue = attr.getStringValue();
                    LOGGER.debug("Found [{}] [{}] for user [{}].", new Object[]{attributeName, attributeValue, context.getUsername()});
                    return attributeValue;
                }
                LOGGER.warn("Could not locate LDAP attribute [{}] for [{}]", attributeName, (Object)entry.getDn());
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Map<LdapEntry, LdapPasswordManagementProperties> findEntries(List<String> filterValues) {
        LinkedHashMap<LdapEntry, LdapPasswordManagementProperties> results = new LinkedHashMap<LdapEntry, LdapPasswordManagementProperties>(0);
        this.ldapProperties.stream().sorted(Comparator.comparing(AbstractLdapProperties::getName)).forEach(Unchecked.consumer(ldap -> {
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)ldap.getSearchFilter(), (String)"user", (List)filterValues);
            LOGGER.debug("Constructed LDAP filter [{}]", (Object)filter);
            ConnectionFactory ldapConnectionFactory = this.connectionFactoryMap.get(ldap.getLdapUrl());
            SearchResponse response = LdapUtils.executeSearchOperation((ConnectionFactory)ldapConnectionFactory, (String)ldap.getBaseDn(), (FilterTemplate)filter, (int)ldap.getPageSize());
            LOGGER.debug("LDAP response [{}]", (Object)response);
            if (LdapUtils.containsResultEntry((SearchResponse)response)) {
                results.put(response.getEntry(), (LdapPasswordManagementProperties)ldap);
            }
        }));
        return results;
    }
}

