/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.web.flow.PasswordManagementCaptchaWebflowConfigurer;
import org.apereo.cas.pm.web.flow.PasswordManagementSingleSignOnParticipationStrategy;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowConfigurer;
import org.apereo.cas.pm.web.flow.actions.HandlePasswordExpirationWarningMessagesAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordResetAction;
import org.apereo.cas.pm.web.flow.actions.PasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.SendPasswordResetInstructionsAction;
import org.apereo.cas.pm.web.flow.actions.ValidatePasswordResetTokenAction;
import org.apereo.cas.pm.web.flow.actions.VerifyPasswordResetRequestAction;
import org.apereo.cas.pm.web.flow.actions.VerifySecurityQuestionsAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.DefaultCaptchaActivationStrategy;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.apereo.cas.web.flow.actions.StaticEventExecutionAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

@Configuration(value="PasswordManagementWebflowConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordManagementWebflowConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementWebflowConfiguration.class);

    @ConditionalOnProperty(prefix="cas.authn.pm.google-recaptcha", name={"enabled"}, havingValue="true")
    @Configuration(value="PasswordManagementCaptchaConfiguration", proxyBeanMethods=false)
    public static class PasswordManagementCaptchaConfiguration {
        @ConditionalOnMissingBean(name={"passwordManagementCaptchaWebflowConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CasWebflowConfigurer passwordManagementCaptchaWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            PasswordManagementCaptchaWebflowConfigurer configurer = new PasswordManagementCaptchaWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
            configurer.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder() + 1);
            return configurer;
        }

        @ConditionalOnMissingBean(name={"passwordResetValidateCaptchaAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action passwordResetValidateCaptchaAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordResetCaptchaActivationStrategy") CaptchaActivationStrategy passwordResetCaptchaActivationStrategy) {
            GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getGoogleRecaptcha();
            return new ValidateCaptchaAction(CaptchaValidator.getInstance((GoogleRecaptchaProperties)recaptcha), passwordResetCaptchaActivationStrategy);
        }

        @Bean
        @ConditionalOnMissingBean(name={"passwordResetCaptchaActivationStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CaptchaActivationStrategy passwordResetCaptchaActivationStrategy(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultCaptchaActivationStrategy(servicesManager);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"passwordResetInitializeCaptchaAction"})
        public Action passwordResetInitializeCaptchaAction(@Qualifier(value="passwordResetCaptchaActivationStrategy") CaptchaActivationStrategy passwordResetCaptchaActivationStrategy, CasConfigurationProperties casProperties) {
            GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getGoogleRecaptcha();
            return new InitializeCaptchaAction(passwordResetCaptchaActivationStrategy, requestContext -> WebUtils.putRecaptchaPasswordManagementEnabled((RequestContext)requestContext, (GoogleRecaptchaProperties)recaptcha), recaptcha);
        }

        @Bean
        @ConditionalOnMissingBean(name={"passwordManagementCaptchaWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementCaptchaWebflowExecutionPlanConfigurer(@Qualifier(value="passwordManagementCaptchaWebflowConfigurer") CasWebflowConfigurer cfg) {
            return plan -> plan.registerWebflowConfigurer(cfg);
        }
    }

    @Configuration(value="PasswordManagementWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementWebflowActionsConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"initPasswordChangeAction"})
        public Action initPasswordChangeAction(CasConfigurationProperties casProperties) {
            return new InitPasswordChangeAction(casProperties);
        }

        @ConditionalOnMissingBean(name={"initPasswordResetAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action initPasswordResetAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            return new InitPasswordResetAction(passwordManagementService);
        }

        @ConditionalOnMissingBean(name={"passwordChangeAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action passwordChangeAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="passwordValidationService") PasswordValidationService passwordValidationService) {
            return new PasswordChangeAction(passwordManagementService, passwordValidationService);
        }

        @ConditionalOnMissingBean(name={"sendPasswordResetInstructionsAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action sendPasswordResetInstructionsAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory) {
            return new SendPasswordResetInstructionsAction(casProperties, communicationsManager, passwordManagementService, ticketRegistry, ticketFactory, defaultPrincipalResolver);
        }

        @ConditionalOnMissingBean(name={"verifyPasswordResetRequestAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action verifyPasswordResetRequestAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return new VerifyPasswordResetRequestAction(casProperties, passwordManagementService, centralAuthenticationService);
        }

        @ConditionalOnMissingBean(name={"handlePasswordExpirationWarningMessagesAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action handlePasswordExpirationWarningMessagesAction() {
            return new HandlePasswordExpirationWarningMessagesAction();
        }

        @ConditionalOnMissingBean(name={"verifySecurityQuestionsAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action verifySecurityQuestionsAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            if (!casProperties.getAuthn().getPm().getReset().isSecurityQuestionsEnabled()) {
                LOGGER.debug("Functionality to handle security questions for password management is not enabled");
                return new StaticEventExecutionAction("success");
            }
            return new VerifySecurityQuestionsAction(passwordManagementService);
        }

        @ConditionalOnMissingBean(name={"validatePasswordResetTokenAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action validatePasswordResetTokenAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return new ValidatePasswordResetTokenAction(passwordManagementService, centralAuthenticationService);
        }
    }

    @Configuration(value="PasswordManagementWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementWebflowBaseConfiguration {
        @ConditionalOnMissingBean(name={"passwordManagementWebflowConfigurer"})
        @Bean
        public CasWebflowConfigurer passwordManagementWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new PasswordManagementWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"passwordManagementCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementCasWebflowExecutionPlanConfigurer(@Qualifier(value="passwordManagementWebflowConfigurer") CasWebflowConfigurer passwordManagementWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(passwordManagementWebflowConfigurer);
        }
    }

    @Configuration(value="PasswordManagementWebflowAdapterConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementWebflowAdapterConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public HandlerAdapter passwordResetHandlerAdapter(@Qualifier(value="loginFlowExecutor") FlowExecutor loginFlowExecutor) {
            FlowHandlerAdapter handler = new FlowHandlerAdapter(){

                public boolean supports(Object handler) {
                    return super.supports(handler) && ((FlowHandler)handler).getFlowId().equals("pswdreset");
                }
            };
            handler.setFlowExecutor(loginFlowExecutor);
            return handler;
        }
    }

    @Configuration(value="PasswordManagementWebflowSingleSignOnConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementWebflowSingleSignOnConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy passwordManagementSingleSignOnParticipationStrategy(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new PasswordManagementSingleSignOnParticipationStrategy(servicesManager, ticketRegistrySupport, authenticationServiceSelectionPlan, centralAuthenticationService);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementSingleSignOnParticipationStrategyConfigurer"})
        public SingleSignOnParticipationStrategyConfigurer passwordManagementSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="passwordManagementSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy passwordManagementSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(passwordManagementSingleSignOnParticipationStrategy);
        }
    }
}

