/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.metadata.resolver.JpaSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.SamlMetadataDocument;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlanConfigurer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.BeanContainer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement
@Configuration(value="SamlIdPJpaRegisteredServiceMetadataConfiguration", proxyBeanMethods=false)
public class SamlIdPJpaRegisteredServiceMetadataConfiguration {

    @Configuration(value="SamlIdPJpaRegisteredServiceMetadataPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaRegisteredServiceMetadataPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jpaSamlRegisteredServiceMetadataResolutionPlanConfigurer"})
        public SamlRegisteredServiceMetadataResolutionPlanConfigurer jpaSamlRegisteredServiceMetadataResolutionPlanConfigurer(@Qualifier(value="jpaSamlRegisteredServiceMetadataResolver") SamlRegisteredServiceMetadataResolver jpaSamlRegisteredServiceMetadataResolver) {
            return plan -> plan.registerMetadataResolver(jpaSamlRegisteredServiceMetadataResolver);
        }
    }

    @Configuration(value="SamlIdPJpaRegisteredServiceMetadataTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaRegisteredServiceMetadataTransactionConfiguration {
        @Bean
        public PlatformTransactionManager transactionManagerSamlMetadata(@Qualifier(value="samlMetadataEntityManagerFactory") EntityManagerFactory emf) {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory(emf);
            return mgmr;
        }
    }

    @Configuration(value="SamlIdPJpaRegisteredServiceMetadataEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaRegisteredServiceMetadataEntityConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaSamlMetadataVendorAdapter(CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<String> jpaSamlMetadataPackagesToScan() {
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)SamlMetadataDocument.class.getPackage().getName()));
        }

        @Bean
        public LocalContainerEntityManagerFactoryBean samlMetadataEntityManagerFactory(CasConfigurationProperties casProperties, @Qualifier(value="jpaSamlMetadataVendorAdapter") JpaVendorAdapter jpaSamlMetadataVendorAdapter, @Qualifier(value="dataSourceSamlMetadata") DataSource dataSourceSamlMetadata, @Qualifier(value="jpaSamlMetadataPackagesToScan") BeanContainer<String> jpaSamlMetadataPackagesToScan, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            SamlIdPMetadataProperties idp = casProperties.getAuthn().getSamlIdp().getMetadata();
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(jpaSamlMetadataVendorAdapter).persistenceUnitName("jpaSamlMetadataContext").dataSource(dataSourceSamlMetadata).packagesToScan(jpaSamlMetadataPackagesToScan.toSet()).build();
            return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)idp.getJpa());
        }
    }

    @Configuration(value="SamlIdPJpaRegisteredServiceMetadataDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaRegisteredServiceMetadataDataConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"dataSourceSamlMetadata"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource dataSourceSamlMetadata(CasConfigurationProperties casProperties) {
            SamlIdPMetadataProperties idp = casProperties.getAuthn().getSamlIdp().getMetadata();
            return JpaBeans.newDataSource((AbstractJpaProperties)idp.getJpa());
        }
    }

    @Configuration(value="SamlIdPJpaRegisteredServiceMetadataResolverConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaRegisteredServiceMetadataResolverConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"jpaSamlRegisteredServiceMetadataResolver"})
        public SamlRegisteredServiceMetadataResolver jpaSamlRegisteredServiceMetadataResolver(CasConfigurationProperties casProperties, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
            return new JpaSamlRegisteredServiceMetadataResolver(idp, openSamlConfigBean);
        }
    }
}

