/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.metadata.resolver;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.support.CloseableDataSource;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlMetadataDocument;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.LoggingUtils;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement
@Transactional(transactionManager="transactionManagerSamlMetadata")
public class JpaSamlRegisteredServiceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaSamlRegisteredServiceMetadataResolver.class);
    private static final int DATA_SOURCE_VALIDITY_TIMEOUT_SECONDS = 5;
    private static final String SELECT_QUERY = String.format("SELECT r from %s r ", SamlMetadataDocument.class.getSimpleName());
    @PersistenceContext(unitName="samlMetadataEntityManagerFactory")
    private transient EntityManager entityManager;

    public JpaSamlRegisteredServiceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        List documents = this.entityManager.createQuery(SELECT_QUERY, SamlMetadataDocument.class).getResultList();
        return documents.stream().map(doc -> this.buildMetadataResolverFrom(service, (SamlMetadataDocument)doc)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean supports(SamlRegisteredService service) {
        try {
            String metadataLocation = service.getMetadataLocation();
            return metadataLocation.trim().startsWith("jdbc://");
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    public void saveOrUpdate(SamlMetadataDocument document) {
        this.entityManager.merge((Object)document);
    }

    public boolean isAvailable(SamlRegisteredService service) {
        if (this.supports(service)) {
            CloseableDataSource ds = JpaBeans.newDataSource((AbstractJpaProperties)this.samlIdPProperties.getMetadata().getJpa());
            return JpaBeans.isValidDataSourceConnection((CloseableDataSource)ds, (int)5);
        }
        return false;
    }

    @Generated
    public String toString() {
        return "JpaSamlRegisteredServiceMetadataResolver(entityManager=" + this.entityManager + ")";
    }
}

